<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBookingReference ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBookingReference
 * @subpackage Arrays
 */
class ArrayOfBookingReference extends AbstractStructArrayBase
{
    /**
     * The BookingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BookingReference[]
     */
    public $BookingReference;
    /**
     * Constructor method for ArrayOfBookingReference
     * @uses ArrayOfBookingReference::setBookingReference()
     * @param \StructType\BookingReference[] $bookingReference
     */
    public function __construct(array $bookingReference = array())
    {
        $this
            ->setBookingReference($bookingReference);
    }
    /**
     * Get BookingReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BookingReference[]|null
     */
    public function getBookingReference()
    {
        return isset($this->BookingReference) ? $this->BookingReference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingReferenceForArrayConstraintsFromSetBookingReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBookingReferenceBookingReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfBookingReferenceBookingReferenceItem instanceof \StructType\BookingReference) {
                $invalidValues[] = is_object($arrayOfBookingReferenceBookingReferenceItem) ? get_class($arrayOfBookingReferenceBookingReferenceItem) : sprintf('%s(%s)', gettype($arrayOfBookingReferenceBookingReferenceItem), var_export($arrayOfBookingReferenceBookingReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingReference property can only contain items of type \StructType\BookingReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BookingReference[] $bookingReference
     * @return \ArrayType\ArrayOfBookingReference
     */
    public function setBookingReference(array $bookingReference = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingReferenceArrayErrorMessage = self::validateBookingReferenceForArrayConstraintsFromSetBookingReference($bookingReference))) {
            throw new \InvalidArgumentException($bookingReferenceArrayErrorMessage, __LINE__);
        }
        if (is_null($bookingReference) || (is_array($bookingReference) && empty($bookingReference))) {
            unset($this->BookingReference);
        } else {
            $this->BookingReference = $bookingReference;
        }
        return $this;
    }
    /**
     * Add item to BookingReference value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingReference $item
     * @return \ArrayType\ArrayOfBookingReference
     */
    public function addToBookingReference(\StructType\BookingReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingReference) {
            throw new \InvalidArgumentException(sprintf('The BookingReference property can only contain items of type \StructType\BookingReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BookingReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BookingReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BookingReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BookingReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BookingReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BookingReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BookingReference
     */
    public function getAttributeName()
    {
        return 'BookingReference';
    }
}
