<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContactInfo
 * @subpackage Structs
 */
class ContactInfo extends AbstractStructBase
{
    /**
     * The ContactID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContactID;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The PersonOrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonOrgID;
    /**
     * The ContactField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactField;
    /**
     * The ContactType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContactType;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Extension;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The AreaCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaCode;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Display
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Display;
    /**
     * The PreferredContactMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PreferredContactMethod;
    /**
     * Constructor method for ContactInfo
     * @uses ContactInfo::setContactID()
     * @uses ContactInfo::setKey()
     * @uses ContactInfo::setPersonOrgID()
     * @uses ContactInfo::setContactField()
     * @uses ContactInfo::setContactType()
     * @uses ContactInfo::setExtension()
     * @uses ContactInfo::setCountryCode()
     * @uses ContactInfo::setAreaCode()
     * @uses ContactInfo::setPhoneNumber()
     * @uses ContactInfo::setDisplay()
     * @uses ContactInfo::setPreferredContactMethod()
     * @param int $contactID
     * @param string $key
     * @param int $personOrgID
     * @param string $contactField
     * @param int $contactType
     * @param string $extension
     * @param string $countryCode
     * @param string $areaCode
     * @param string $phoneNumber
     * @param string $display
     * @param bool $preferredContactMethod
     */
    public function __construct($contactID = null, $key = null, $personOrgID = null, $contactField = null, $contactType = null, $extension = null, $countryCode = null, $areaCode = null, $phoneNumber = null, $display = null, $preferredContactMethod = null)
    {
        $this
            ->setContactID($contactID)
            ->setKey($key)
            ->setPersonOrgID($personOrgID)
            ->setContactField($contactField)
            ->setContactType($contactType)
            ->setExtension($extension)
            ->setCountryCode($countryCode)
            ->setAreaCode($areaCode)
            ->setPhoneNumber($phoneNumber)
            ->setDisplay($display)
            ->setPreferredContactMethod($preferredContactMethod);
    }
    /**
     * Get ContactID value
     * @return int|null
     */
    public function getContactID()
    {
        return $this->ContactID;
    }
    /**
     * Set ContactID value
     * @param int $contactID
     * @return \StructType\ContactInfo
     */
    public function setContactID($contactID = null)
    {
        // validation for constraint: int
        if (!is_null($contactID) && !(is_int($contactID) || ctype_digit($contactID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactID, true), gettype($contactID)), __LINE__);
        }
        $this->ContactID = $contactID;
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\ContactInfo
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\ContactInfo
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get ContactField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactField()
    {
        return isset($this->ContactField) ? $this->ContactField : null;
    }
    /**
     * Set ContactField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactField
     * @return \StructType\ContactInfo
     */
    public function setContactField($contactField = null)
    {
        // validation for constraint: string
        if (!is_null($contactField) && !is_string($contactField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactField, true), gettype($contactField)), __LINE__);
        }
        if (is_null($contactField) || (is_array($contactField) && empty($contactField))) {
            unset($this->ContactField);
        } else {
            $this->ContactField = $contactField;
        }
        return $this;
    }
    /**
     * Get ContactType value
     * @return int|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @param int $contactType
     * @return \StructType\ContactInfo
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: int
        if (!is_null($contactType) && !(is_int($contactType) || ctype_digit($contactType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactType, true), gettype($contactType)), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get Extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtension()
    {
        return isset($this->Extension) ? $this->Extension : null;
    }
    /**
     * Set Extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extension
     * @return \StructType\ContactInfo
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        if (is_null($extension) || (is_array($extension) && empty($extension))) {
            unset($this->Extension);
        } else {
            $this->Extension = $extension;
        }
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \StructType\ContactInfo
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get AreaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaCode()
    {
        return isset($this->AreaCode) ? $this->AreaCode : null;
    }
    /**
     * Set AreaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaCode
     * @return \StructType\ContactInfo
     */
    public function setAreaCode($areaCode = null)
    {
        // validation for constraint: string
        if (!is_null($areaCode) && !is_string($areaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaCode, true), gettype($areaCode)), __LINE__);
        }
        if (is_null($areaCode) || (is_array($areaCode) && empty($areaCode))) {
            unset($this->AreaCode);
        } else {
            $this->AreaCode = $areaCode;
        }
        return $this;
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \StructType\ContactInfo
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Get Display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplay()
    {
        return isset($this->Display) ? $this->Display : null;
    }
    /**
     * Set Display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $display
     * @return \StructType\ContactInfo
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($display, true), gettype($display)), __LINE__);
        }
        if (is_null($display) || (is_array($display) && empty($display))) {
            unset($this->Display);
        } else {
            $this->Display = $display;
        }
        return $this;
    }
    /**
     * Get PreferredContactMethod value
     * @return bool|null
     */
    public function getPreferredContactMethod()
    {
        return $this->PreferredContactMethod;
    }
    /**
     * Set PreferredContactMethod value
     * @param bool $preferredContactMethod
     * @return \StructType\ContactInfo
     */
    public function setPreferredContactMethod($preferredContactMethod = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferredContactMethod) && !is_bool($preferredContactMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferredContactMethod, true), gettype($preferredContactMethod)), __LINE__);
        }
        $this->PreferredContactMethod = $preferredContactMethod;
        return $this;
    }
}
