<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrievePNRBookingAgent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrievePNRBookingAgent $parameters
     * @return \StructType\RetrievePNRBookingAgentResponse|bool
     */
    public function RetrievePNRBookingAgent(\StructType\RetrievePNRBookingAgent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrievePNRBookingAgent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveSystemOptionValue
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveSystemOptionValue $parameters
     * @return \StructType\RetrieveSystemOptionValueResponse|bool
     */
    public function RetrieveSystemOptionValue(\StructType\RetrieveSystemOptionValue $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveSystemOptionValue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveHtmlReciept
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveHtmlReciept $parameters
     * @return \StructType\RetrieveHtmlRecieptResponse|bool
     */
    public function RetrieveHtmlReciept(\StructType\RetrieveHtmlReciept $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveHtmlReciept($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveServiceInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveServiceInformation $parameters
     * @return \StructType\RetrieveServiceInformationResponse|bool
     */
    public function RetrieveServiceInformation(\StructType\RetrieveServiceInformation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveServiceInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveBuddyListTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveBuddyListTypes $parameters
     * @return \StructType\RetrieveBuddyListTypesResponse|bool
     */
    public function RetrieveBuddyListTypes(\StructType\RetrieveBuddyListTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveBuddyListTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveBuddyListTypesResponse|\StructType\RetrieveHtmlRecieptResponse|\StructType\RetrievePNRBookingAgentResponse|\StructType\RetrieveServiceInformationResponse|\StructType\RetrieveSystemOptionValueResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
