<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfHotel ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfHotel
 * @subpackage Arrays
 */
class ArrayOfHotel extends AbstractStructArrayBase
{
    /**
     * The Hotel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hotel[]
     */
    public $Hotel;
    /**
     * Constructor method for ArrayOfHotel
     * @uses ArrayOfHotel::setHotel()
     * @param \StructType\Hotel[] $hotel
     */
    public function __construct(array $hotel = array())
    {
        $this
            ->setHotel($hotel);
    }
    /**
     * Get Hotel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hotel[]|null
     */
    public function getHotel()
    {
        return isset($this->Hotel) ? $this->Hotel : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelForArrayConstraintsFromSetHotel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfHotelHotelItem) {
            // validation for constraint: itemType
            if (!$arrayOfHotelHotelItem instanceof \StructType\Hotel) {
                $invalidValues[] = is_object($arrayOfHotelHotelItem) ? get_class($arrayOfHotelHotelItem) : sprintf('%s(%s)', gettype($arrayOfHotelHotelItem), var_export($arrayOfHotelHotelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel property can only contain items of type \StructType\Hotel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel[] $hotel
     * @return \ArrayType\ArrayOfHotel
     */
    public function setHotel(array $hotel = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelArrayErrorMessage = self::validateHotelForArrayConstraintsFromSetHotel($hotel))) {
            throw new \InvalidArgumentException($hotelArrayErrorMessage, __LINE__);
        }
        if (is_null($hotel) || (is_array($hotel) && empty($hotel))) {
            unset($this->Hotel);
        } else {
            $this->Hotel = $hotel;
        }
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel $item
     * @return \ArrayType\ArrayOfHotel
     */
    public function addToHotel(\StructType\Hotel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hotel) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of type \StructType\Hotel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Hotel|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Hotel|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Hotel|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Hotel|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Hotel|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Hotel
     */
    public function getAttributeName()
    {
        return 'Hotel';
    }
}
