<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Payment
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The ReservationPaymentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservationPaymentID;
    /**
     * The CardHolder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardHolder;
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PaymentAmount;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CVCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CVCode;
    /**
     * The Authorizationcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Authorizationcode;
    /**
     * The TerminalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TerminalID;
    /**
     * The CurrencyPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyPaid;
    /**
     * The CheckNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CheckNumber;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionID;
    /**
     * The ValueCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValueCode;
    /**
     * The TransactionIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionIndicator;
    /**
     * The SettlementBatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SettlementBatch;
    /**
     * The AuthorizedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AuthorizedAmount;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherNumber;
    /**
     * The FFNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FFNumber;
    /**
     * The Miles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Miles;
    /**
     * The PaymentComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentComment;
    /**
     * The BaseCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseCurrency;
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BaseAmount;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeRateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeRateDate;
    /**
     * The DocumentReceivedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentReceivedBy;
    /**
     * The BatchProcessStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BatchProcessStart;
    /**
     * The BatchProcessExtracted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BatchProcessExtracted;
    /**
     * The TicketCouponNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketCouponNumber;
    /**
     * The ATCANDateProcessed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ATCANDateProcessed;
    /**
     * The TicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketType;
    /**
     * The GcxID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GcxID;
    /**
     * The GcxOptOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GcxOptOption;
    /**
     * The GcxExported
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GcxExported;
    /**
     * The GcxExportedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GcxExportedDate;
    /**
     * The OriginalCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalCurrency;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OriginalAmount;
    /**
     * The IATANum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATANum;
    /**
     * The ProcessorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessorID;
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantID;
    /**
     * The ProcessorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessorName;
    /**
     * The OriginalPaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalPaymentMethod;
    /**
     * The TransactionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionStatus;
    /**
     * The ResponseMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseMessage;
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseCode;
    /**
     * The PersonOrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonOrgID;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Postal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postal;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The DatePaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatePaid;
    /**
     * The UserData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserData;
    /**
     * The CardVerification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardVerification;
    /**
     * The GrossAmtResCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $GrossAmtResCurrency;
    /**
     * The GrossAmtPayCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $GrossAmtPayCurrency;
    /**
     * The NetAmtResCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NetAmtResCurrency;
    /**
     * The CommissionDeductedResCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CommissionDeductedResCurrency;
    /**
     * The CommissionDeductedPayCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CommissionDeductedPayCurrency;
    /**
     * The RptNetFrmResCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RptNetFrmResCurrency;
    /**
     * The RptCommissionFromResCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RptCommissionFromResCurrency;
    /**
     * The RptCommissionFromPayCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RptCommissionFromPayCurrency;
    /**
     * The TotalRefundResCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalRefundResCurrency;
    /**
     * The TotalRefundRptCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalRefundRptCurrency;
    /**
     * The TotalRefundPayCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalRefundPayCurrency;
    /**
     * The RedeemedVoucherAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RedeemedVoucherAmount;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserID;
    /**
     * The OriginalPaymentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginalPaymentID;
    /**
     * The PaymentReservationChannelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentReservationChannelID;
    /**
     * The AncillaryData01
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AncillaryData01;
    /**
     * The AncillaryData02
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AncillaryData02;
    /**
     * The AncillaryData03
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AncillaryData03;
    /**
     * The AncillaryData04
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AncillaryData04;
    /**
     * The AncillaryData05
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AncillaryData05;
    /**
     * The MetaData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPaymentMetaData
     */
    public $MetaData;
    /**
     * Constructor method for Payment
     * @uses Payment::setKey()
     * @uses Payment::setReservationPaymentID()
     * @uses Payment::setCardHolder()
     * @uses Payment::setPaymentAmount()
     * @uses Payment::setExpirationDate()
     * @uses Payment::setCardNumber()
     * @uses Payment::setCVCode()
     * @uses Payment::setAuthorizationcode()
     * @uses Payment::setTerminalID()
     * @uses Payment::setCurrencyPaid()
     * @uses Payment::setCheckNumber()
     * @uses Payment::setReference()
     * @uses Payment::setResult()
     * @uses Payment::setTransactionID()
     * @uses Payment::setValueCode()
     * @uses Payment::setTransactionIndicator()
     * @uses Payment::setSettlementBatch()
     * @uses Payment::setAuthorizedAmount()
     * @uses Payment::setVoucherNumber()
     * @uses Payment::setFFNumber()
     * @uses Payment::setMiles()
     * @uses Payment::setPaymentComment()
     * @uses Payment::setBaseCurrency()
     * @uses Payment::setBaseAmount()
     * @uses Payment::setExchangeRate()
     * @uses Payment::setExchangeRateDate()
     * @uses Payment::setDocumentReceivedBy()
     * @uses Payment::setBatchProcessStart()
     * @uses Payment::setBatchProcessExtracted()
     * @uses Payment::setTicketCouponNumber()
     * @uses Payment::setATCANDateProcessed()
     * @uses Payment::setTicketType()
     * @uses Payment::setGcxID()
     * @uses Payment::setGcxOptOption()
     * @uses Payment::setGcxExported()
     * @uses Payment::setGcxExportedDate()
     * @uses Payment::setOriginalCurrency()
     * @uses Payment::setOriginalAmount()
     * @uses Payment::setIATANum()
     * @uses Payment::setProcessorID()
     * @uses Payment::setMerchantID()
     * @uses Payment::setProcessorName()
     * @uses Payment::setOriginalPaymentMethod()
     * @uses Payment::setTransactionStatus()
     * @uses Payment::setResponseMessage()
     * @uses Payment::setResponseCode()
     * @uses Payment::setPersonOrgID()
     * @uses Payment::setFirstName()
     * @uses Payment::setLastName()
     * @uses Payment::setCompanyName()
     * @uses Payment::setAddress()
     * @uses Payment::setAddress2()
     * @uses Payment::setCity()
     * @uses Payment::setState()
     * @uses Payment::setPostal()
     * @uses Payment::setCountry()
     * @uses Payment::setPaymentMethod()
     * @uses Payment::setDatePaid()
     * @uses Payment::setUserData()
     * @uses Payment::setCardVerification()
     * @uses Payment::setGrossAmtResCurrency()
     * @uses Payment::setGrossAmtPayCurrency()
     * @uses Payment::setNetAmtResCurrency()
     * @uses Payment::setCommissionDeductedResCurrency()
     * @uses Payment::setCommissionDeductedPayCurrency()
     * @uses Payment::setRptNetFrmResCurrency()
     * @uses Payment::setRptCommissionFromResCurrency()
     * @uses Payment::setRptCommissionFromPayCurrency()
     * @uses Payment::setTotalRefundResCurrency()
     * @uses Payment::setTotalRefundRptCurrency()
     * @uses Payment::setTotalRefundPayCurrency()
     * @uses Payment::setRedeemedVoucherAmount()
     * @uses Payment::setUserID()
     * @uses Payment::setOriginalPaymentID()
     * @uses Payment::setPaymentReservationChannelID()
     * @uses Payment::setAncillaryData01()
     * @uses Payment::setAncillaryData02()
     * @uses Payment::setAncillaryData03()
     * @uses Payment::setAncillaryData04()
     * @uses Payment::setAncillaryData05()
     * @uses Payment::setMetaData()
     * @param string $key
     * @param int $reservationPaymentID
     * @param string $cardHolder
     * @param float $paymentAmount
     * @param string $expirationDate
     * @param string $cardNumber
     * @param string $cVCode
     * @param string $authorizationcode
     * @param int $terminalID
     * @param string $currencyPaid
     * @param int $checkNumber
     * @param string $reference
     * @param string $result
     * @param string $transactionID
     * @param string $valueCode
     * @param int $transactionIndicator
     * @param string $settlementBatch
     * @param float $authorizedAmount
     * @param int $voucherNumber
     * @param string $fFNumber
     * @param int $miles
     * @param string $paymentComment
     * @param string $baseCurrency
     * @param float $baseAmount
     * @param float $exchangeRate
     * @param string $exchangeRateDate
     * @param string $documentReceivedBy
     * @param string $batchProcessStart
     * @param int $batchProcessExtracted
     * @param string $ticketCouponNumber
     * @param string $aTCANDateProcessed
     * @param string $ticketType
     * @param string $gcxID
     * @param string $gcxOptOption
     * @param int $gcxExported
     * @param string $gcxExportedDate
     * @param string $originalCurrency
     * @param float $originalAmount
     * @param string $iATANum
     * @param string $processorID
     * @param string $merchantID
     * @param string $processorName
     * @param string $originalPaymentMethod
     * @param int $transactionStatus
     * @param string $responseMessage
     * @param string $responseCode
     * @param int $personOrgID
     * @param string $firstName
     * @param string $lastName
     * @param string $companyName
     * @param string $address
     * @param string $address2
     * @param string $city
     * @param string $state
     * @param string $postal
     * @param string $country
     * @param string $paymentMethod
     * @param string $datePaid
     * @param string $userData
     * @param string $cardVerification
     * @param float $grossAmtResCurrency
     * @param float $grossAmtPayCurrency
     * @param float $netAmtResCurrency
     * @param float $commissionDeductedResCurrency
     * @param float $commissionDeductedPayCurrency
     * @param float $rptNetFrmResCurrency
     * @param float $rptCommissionFromResCurrency
     * @param float $rptCommissionFromPayCurrency
     * @param float $totalRefundResCurrency
     * @param float $totalRefundRptCurrency
     * @param float $totalRefundPayCurrency
     * @param float $redeemedVoucherAmount
     * @param string $userID
     * @param int $originalPaymentID
     * @param int $paymentReservationChannelID
     * @param string $ancillaryData01
     * @param string $ancillaryData02
     * @param string $ancillaryData03
     * @param string $ancillaryData04
     * @param string $ancillaryData05
     * @param \ArrayType\ArrayOfPaymentMetaData $metaData
     */
    public function __construct($key = null, $reservationPaymentID = null, $cardHolder = null, $paymentAmount = null, $expirationDate = null, $cardNumber = null, $cVCode = null, $authorizationcode = null, $terminalID = null, $currencyPaid = null, $checkNumber = null, $reference = null, $result = null, $transactionID = null, $valueCode = null, $transactionIndicator = null, $settlementBatch = null, $authorizedAmount = null, $voucherNumber = null, $fFNumber = null, $miles = null, $paymentComment = null, $baseCurrency = null, $baseAmount = null, $exchangeRate = null, $exchangeRateDate = null, $documentReceivedBy = null, $batchProcessStart = null, $batchProcessExtracted = null, $ticketCouponNumber = null, $aTCANDateProcessed = null, $ticketType = null, $gcxID = null, $gcxOptOption = null, $gcxExported = null, $gcxExportedDate = null, $originalCurrency = null, $originalAmount = null, $iATANum = null, $processorID = null, $merchantID = null, $processorName = null, $originalPaymentMethod = null, $transactionStatus = null, $responseMessage = null, $responseCode = null, $personOrgID = null, $firstName = null, $lastName = null, $companyName = null, $address = null, $address2 = null, $city = null, $state = null, $postal = null, $country = null, $paymentMethod = null, $datePaid = null, $userData = null, $cardVerification = null, $grossAmtResCurrency = null, $grossAmtPayCurrency = null, $netAmtResCurrency = null, $commissionDeductedResCurrency = null, $commissionDeductedPayCurrency = null, $rptNetFrmResCurrency = null, $rptCommissionFromResCurrency = null, $rptCommissionFromPayCurrency = null, $totalRefundResCurrency = null, $totalRefundRptCurrency = null, $totalRefundPayCurrency = null, $redeemedVoucherAmount = null, $userID = null, $originalPaymentID = null, $paymentReservationChannelID = null, $ancillaryData01 = null, $ancillaryData02 = null, $ancillaryData03 = null, $ancillaryData04 = null, $ancillaryData05 = null, \ArrayType\ArrayOfPaymentMetaData $metaData = null)
    {
        $this
            ->setKey($key)
            ->setReservationPaymentID($reservationPaymentID)
            ->setCardHolder($cardHolder)
            ->setPaymentAmount($paymentAmount)
            ->setExpirationDate($expirationDate)
            ->setCardNumber($cardNumber)
            ->setCVCode($cVCode)
            ->setAuthorizationcode($authorizationcode)
            ->setTerminalID($terminalID)
            ->setCurrencyPaid($currencyPaid)
            ->setCheckNumber($checkNumber)
            ->setReference($reference)
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setValueCode($valueCode)
            ->setTransactionIndicator($transactionIndicator)
            ->setSettlementBatch($settlementBatch)
            ->setAuthorizedAmount($authorizedAmount)
            ->setVoucherNumber($voucherNumber)
            ->setFFNumber($fFNumber)
            ->setMiles($miles)
            ->setPaymentComment($paymentComment)
            ->setBaseCurrency($baseCurrency)
            ->setBaseAmount($baseAmount)
            ->setExchangeRate($exchangeRate)
            ->setExchangeRateDate($exchangeRateDate)
            ->setDocumentReceivedBy($documentReceivedBy)
            ->setBatchProcessStart($batchProcessStart)
            ->setBatchProcessExtracted($batchProcessExtracted)
            ->setTicketCouponNumber($ticketCouponNumber)
            ->setATCANDateProcessed($aTCANDateProcessed)
            ->setTicketType($ticketType)
            ->setGcxID($gcxID)
            ->setGcxOptOption($gcxOptOption)
            ->setGcxExported($gcxExported)
            ->setGcxExportedDate($gcxExportedDate)
            ->setOriginalCurrency($originalCurrency)
            ->setOriginalAmount($originalAmount)
            ->setIATANum($iATANum)
            ->setProcessorID($processorID)
            ->setMerchantID($merchantID)
            ->setProcessorName($processorName)
            ->setOriginalPaymentMethod($originalPaymentMethod)
            ->setTransactionStatus($transactionStatus)
            ->setResponseMessage($responseMessage)
            ->setResponseCode($responseCode)
            ->setPersonOrgID($personOrgID)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompanyName($companyName)
            ->setAddress($address)
            ->setAddress2($address2)
            ->setCity($city)
            ->setState($state)
            ->setPostal($postal)
            ->setCountry($country)
            ->setPaymentMethod($paymentMethod)
            ->setDatePaid($datePaid)
            ->setUserData($userData)
            ->setCardVerification($cardVerification)
            ->setGrossAmtResCurrency($grossAmtResCurrency)
            ->setGrossAmtPayCurrency($grossAmtPayCurrency)
            ->setNetAmtResCurrency($netAmtResCurrency)
            ->setCommissionDeductedResCurrency($commissionDeductedResCurrency)
            ->setCommissionDeductedPayCurrency($commissionDeductedPayCurrency)
            ->setRptNetFrmResCurrency($rptNetFrmResCurrency)
            ->setRptCommissionFromResCurrency($rptCommissionFromResCurrency)
            ->setRptCommissionFromPayCurrency($rptCommissionFromPayCurrency)
            ->setTotalRefundResCurrency($totalRefundResCurrency)
            ->setTotalRefundRptCurrency($totalRefundRptCurrency)
            ->setTotalRefundPayCurrency($totalRefundPayCurrency)
            ->setRedeemedVoucherAmount($redeemedVoucherAmount)
            ->setUserID($userID)
            ->setOriginalPaymentID($originalPaymentID)
            ->setPaymentReservationChannelID($paymentReservationChannelID)
            ->setAncillaryData01($ancillaryData01)
            ->setAncillaryData02($ancillaryData02)
            ->setAncillaryData03($ancillaryData03)
            ->setAncillaryData04($ancillaryData04)
            ->setAncillaryData05($ancillaryData05)
            ->setMetaData($metaData);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\Payment
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get ReservationPaymentID value
     * @return int|null
     */
    public function getReservationPaymentID()
    {
        return $this->ReservationPaymentID;
    }
    /**
     * Set ReservationPaymentID value
     * @param int $reservationPaymentID
     * @return \StructType\Payment
     */
    public function setReservationPaymentID($reservationPaymentID = null)
    {
        // validation for constraint: int
        if (!is_null($reservationPaymentID) && !(is_int($reservationPaymentID) || ctype_digit($reservationPaymentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationPaymentID, true), gettype($reservationPaymentID)), __LINE__);
        }
        $this->ReservationPaymentID = $reservationPaymentID;
        return $this;
    }
    /**
     * Get CardHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardHolder()
    {
        return isset($this->CardHolder) ? $this->CardHolder : null;
    }
    /**
     * Set CardHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardHolder
     * @return \StructType\Payment
     */
    public function setCardHolder($cardHolder = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolder) && !is_string($cardHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolder, true), gettype($cardHolder)), __LINE__);
        }
        if (is_null($cardHolder) || (is_array($cardHolder) && empty($cardHolder))) {
            unset($this->CardHolder);
        } else {
            $this->CardHolder = $cardHolder;
        }
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \StructType\Payment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\Payment
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \StructType\Payment
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CVCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCVCode()
    {
        return isset($this->CVCode) ? $this->CVCode : null;
    }
    /**
     * Set CVCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cVCode
     * @return \StructType\Payment
     */
    public function setCVCode($cVCode = null)
    {
        // validation for constraint: string
        if (!is_null($cVCode) && !is_string($cVCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVCode, true), gettype($cVCode)), __LINE__);
        }
        if (is_null($cVCode) || (is_array($cVCode) && empty($cVCode))) {
            unset($this->CVCode);
        } else {
            $this->CVCode = $cVCode;
        }
        return $this;
    }
    /**
     * Get Authorizationcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizationcode()
    {
        return isset($this->Authorizationcode) ? $this->Authorizationcode : null;
    }
    /**
     * Set Authorizationcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizationcode
     * @return \StructType\Payment
     */
    public function setAuthorizationcode($authorizationcode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationcode) && !is_string($authorizationcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationcode, true), gettype($authorizationcode)), __LINE__);
        }
        if (is_null($authorizationcode) || (is_array($authorizationcode) && empty($authorizationcode))) {
            unset($this->Authorizationcode);
        } else {
            $this->Authorizationcode = $authorizationcode;
        }
        return $this;
    }
    /**
     * Get TerminalID value
     * @return int|null
     */
    public function getTerminalID()
    {
        return $this->TerminalID;
    }
    /**
     * Set TerminalID value
     * @param int $terminalID
     * @return \StructType\Payment
     */
    public function setTerminalID($terminalID = null)
    {
        // validation for constraint: int
        if (!is_null($terminalID) && !(is_int($terminalID) || ctype_digit($terminalID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalID, true), gettype($terminalID)), __LINE__);
        }
        $this->TerminalID = $terminalID;
        return $this;
    }
    /**
     * Get CurrencyPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyPaid()
    {
        return isset($this->CurrencyPaid) ? $this->CurrencyPaid : null;
    }
    /**
     * Set CurrencyPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyPaid
     * @return \StructType\Payment
     */
    public function setCurrencyPaid($currencyPaid = null)
    {
        // validation for constraint: string
        if (!is_null($currencyPaid) && !is_string($currencyPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyPaid, true), gettype($currencyPaid)), __LINE__);
        }
        if (is_null($currencyPaid) || (is_array($currencyPaid) && empty($currencyPaid))) {
            unset($this->CurrencyPaid);
        } else {
            $this->CurrencyPaid = $currencyPaid;
        }
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return int|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param int $checkNumber
     * @return \StructType\Payment
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: int
        if (!is_null($checkNumber) && !(is_int($checkNumber) || ctype_digit($checkNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($checkNumber, true), gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get Reference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference()
    {
        return isset($this->Reference) ? $this->Reference : null;
    }
    /**
     * Set Reference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference
     * @return \StructType\Payment
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        if (is_null($reference) || (is_array($reference) && empty($reference))) {
            unset($this->Reference);
        } else {
            $this->Reference = $reference;
        }
        return $this;
    }
    /**
     * Get Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResult()
    {
        return isset($this->Result) ? $this->Result : null;
    }
    /**
     * Set Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $result
     * @return \StructType\Payment
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        if (is_null($result) || (is_array($result) && empty($result))) {
            unset($this->Result);
        } else {
            $this->Result = $result;
        }
        return $this;
    }
    /**
     * Get TransactionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionID()
    {
        return isset($this->TransactionID) ? $this->TransactionID : null;
    }
    /**
     * Set TransactionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionID
     * @return \StructType\Payment
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        if (is_null($transactionID) || (is_array($transactionID) && empty($transactionID))) {
            unset($this->TransactionID);
        } else {
            $this->TransactionID = $transactionID;
        }
        return $this;
    }
    /**
     * Get ValueCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueCode()
    {
        return isset($this->ValueCode) ? $this->ValueCode : null;
    }
    /**
     * Set ValueCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valueCode
     * @return \StructType\Payment
     */
    public function setValueCode($valueCode = null)
    {
        // validation for constraint: string
        if (!is_null($valueCode) && !is_string($valueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueCode, true), gettype($valueCode)), __LINE__);
        }
        if (is_null($valueCode) || (is_array($valueCode) && empty($valueCode))) {
            unset($this->ValueCode);
        } else {
            $this->ValueCode = $valueCode;
        }
        return $this;
    }
    /**
     * Get TransactionIndicator value
     * @return int|null
     */
    public function getTransactionIndicator()
    {
        return $this->TransactionIndicator;
    }
    /**
     * Set TransactionIndicator value
     * @param int $transactionIndicator
     * @return \StructType\Payment
     */
    public function setTransactionIndicator($transactionIndicator = null)
    {
        // validation for constraint: int
        if (!is_null($transactionIndicator) && !(is_int($transactionIndicator) || ctype_digit($transactionIndicator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionIndicator, true), gettype($transactionIndicator)), __LINE__);
        }
        $this->TransactionIndicator = $transactionIndicator;
        return $this;
    }
    /**
     * Get SettlementBatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSettlementBatch()
    {
        return isset($this->SettlementBatch) ? $this->SettlementBatch : null;
    }
    /**
     * Set SettlementBatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $settlementBatch
     * @return \StructType\Payment
     */
    public function setSettlementBatch($settlementBatch = null)
    {
        // validation for constraint: string
        if (!is_null($settlementBatch) && !is_string($settlementBatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementBatch, true), gettype($settlementBatch)), __LINE__);
        }
        if (is_null($settlementBatch) || (is_array($settlementBatch) && empty($settlementBatch))) {
            unset($this->SettlementBatch);
        } else {
            $this->SettlementBatch = $settlementBatch;
        }
        return $this;
    }
    /**
     * Get AuthorizedAmount value
     * @return float|null
     */
    public function getAuthorizedAmount()
    {
        return $this->AuthorizedAmount;
    }
    /**
     * Set AuthorizedAmount value
     * @param float $authorizedAmount
     * @return \StructType\Payment
     */
    public function setAuthorizedAmount($authorizedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($authorizedAmount) && !(is_float($authorizedAmount) || is_numeric($authorizedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($authorizedAmount, true), gettype($authorizedAmount)), __LINE__);
        }
        $this->AuthorizedAmount = $authorizedAmount;
        return $this;
    }
    /**
     * Get VoucherNumber value
     * @return int|null
     */
    public function getVoucherNumber()
    {
        return $this->VoucherNumber;
    }
    /**
     * Set VoucherNumber value
     * @param int $voucherNumber
     * @return \StructType\Payment
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: int
        if (!is_null($voucherNumber) && !(is_int($voucherNumber) || ctype_digit($voucherNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->VoucherNumber = $voucherNumber;
        return $this;
    }
    /**
     * Get FFNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFFNumber()
    {
        return isset($this->FFNumber) ? $this->FFNumber : null;
    }
    /**
     * Set FFNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fFNumber
     * @return \StructType\Payment
     */
    public function setFFNumber($fFNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fFNumber) && !is_string($fFNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fFNumber, true), gettype($fFNumber)), __LINE__);
        }
        if (is_null($fFNumber) || (is_array($fFNumber) && empty($fFNumber))) {
            unset($this->FFNumber);
        } else {
            $this->FFNumber = $fFNumber;
        }
        return $this;
    }
    /**
     * Get Miles value
     * @return int|null
     */
    public function getMiles()
    {
        return $this->Miles;
    }
    /**
     * Set Miles value
     * @param int $miles
     * @return \StructType\Payment
     */
    public function setMiles($miles = null)
    {
        // validation for constraint: int
        if (!is_null($miles) && !(is_int($miles) || ctype_digit($miles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($miles, true), gettype($miles)), __LINE__);
        }
        $this->Miles = $miles;
        return $this;
    }
    /**
     * Get PaymentComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentComment()
    {
        return isset($this->PaymentComment) ? $this->PaymentComment : null;
    }
    /**
     * Set PaymentComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentComment
     * @return \StructType\Payment
     */
    public function setPaymentComment($paymentComment = null)
    {
        // validation for constraint: string
        if (!is_null($paymentComment) && !is_string($paymentComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentComment, true), gettype($paymentComment)), __LINE__);
        }
        if (is_null($paymentComment) || (is_array($paymentComment) && empty($paymentComment))) {
            unset($this->PaymentComment);
        } else {
            $this->PaymentComment = $paymentComment;
        }
        return $this;
    }
    /**
     * Get BaseCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseCurrency()
    {
        return isset($this->BaseCurrency) ? $this->BaseCurrency : null;
    }
    /**
     * Set BaseCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseCurrency
     * @return \StructType\Payment
     */
    public function setBaseCurrency($baseCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($baseCurrency) && !is_string($baseCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseCurrency, true), gettype($baseCurrency)), __LINE__);
        }
        if (is_null($baseCurrency) || (is_array($baseCurrency) && empty($baseCurrency))) {
            unset($this->BaseCurrency);
        } else {
            $this->BaseCurrency = $baseCurrency;
        }
        return $this;
    }
    /**
     * Get BaseAmount value
     * @return float|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param float $baseAmount
     * @return \StructType\Payment
     */
    public function setBaseAmount($baseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($baseAmount) && !(is_float($baseAmount) || is_numeric($baseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseAmount, true), gettype($baseAmount)), __LINE__);
        }
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\Payment
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ExchangeRateDate value
     * @return string|null
     */
    public function getExchangeRateDate()
    {
        return $this->ExchangeRateDate;
    }
    /**
     * Set ExchangeRateDate value
     * @param string $exchangeRateDate
     * @return \StructType\Payment
     */
    public function setExchangeRateDate($exchangeRateDate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateDate) && !is_string($exchangeRateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateDate, true), gettype($exchangeRateDate)), __LINE__);
        }
        $this->ExchangeRateDate = $exchangeRateDate;
        return $this;
    }
    /**
     * Get DocumentReceivedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentReceivedBy()
    {
        return isset($this->DocumentReceivedBy) ? $this->DocumentReceivedBy : null;
    }
    /**
     * Set DocumentReceivedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentReceivedBy
     * @return \StructType\Payment
     */
    public function setDocumentReceivedBy($documentReceivedBy = null)
    {
        // validation for constraint: string
        if (!is_null($documentReceivedBy) && !is_string($documentReceivedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentReceivedBy, true), gettype($documentReceivedBy)), __LINE__);
        }
        if (is_null($documentReceivedBy) || (is_array($documentReceivedBy) && empty($documentReceivedBy))) {
            unset($this->DocumentReceivedBy);
        } else {
            $this->DocumentReceivedBy = $documentReceivedBy;
        }
        return $this;
    }
    /**
     * Get BatchProcessStart value
     * @return string|null
     */
    public function getBatchProcessStart()
    {
        return $this->BatchProcessStart;
    }
    /**
     * Set BatchProcessStart value
     * @param string $batchProcessStart
     * @return \StructType\Payment
     */
    public function setBatchProcessStart($batchProcessStart = null)
    {
        // validation for constraint: string
        if (!is_null($batchProcessStart) && !is_string($batchProcessStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchProcessStart, true), gettype($batchProcessStart)), __LINE__);
        }
        $this->BatchProcessStart = $batchProcessStart;
        return $this;
    }
    /**
     * Get BatchProcessExtracted value
     * @return int|null
     */
    public function getBatchProcessExtracted()
    {
        return $this->BatchProcessExtracted;
    }
    /**
     * Set BatchProcessExtracted value
     * @param int $batchProcessExtracted
     * @return \StructType\Payment
     */
    public function setBatchProcessExtracted($batchProcessExtracted = null)
    {
        // validation for constraint: int
        if (!is_null($batchProcessExtracted) && !(is_int($batchProcessExtracted) || ctype_digit($batchProcessExtracted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batchProcessExtracted, true), gettype($batchProcessExtracted)), __LINE__);
        }
        $this->BatchProcessExtracted = $batchProcessExtracted;
        return $this;
    }
    /**
     * Get TicketCouponNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketCouponNumber()
    {
        return isset($this->TicketCouponNumber) ? $this->TicketCouponNumber : null;
    }
    /**
     * Set TicketCouponNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketCouponNumber
     * @return \StructType\Payment
     */
    public function setTicketCouponNumber($ticketCouponNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketCouponNumber) && !is_string($ticketCouponNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketCouponNumber, true), gettype($ticketCouponNumber)), __LINE__);
        }
        if (is_null($ticketCouponNumber) || (is_array($ticketCouponNumber) && empty($ticketCouponNumber))) {
            unset($this->TicketCouponNumber);
        } else {
            $this->TicketCouponNumber = $ticketCouponNumber;
        }
        return $this;
    }
    /**
     * Get ATCANDateProcessed value
     * @return string|null
     */
    public function getATCANDateProcessed()
    {
        return $this->ATCANDateProcessed;
    }
    /**
     * Set ATCANDateProcessed value
     * @param string $aTCANDateProcessed
     * @return \StructType\Payment
     */
    public function setATCANDateProcessed($aTCANDateProcessed = null)
    {
        // validation for constraint: string
        if (!is_null($aTCANDateProcessed) && !is_string($aTCANDateProcessed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aTCANDateProcessed, true), gettype($aTCANDateProcessed)), __LINE__);
        }
        $this->ATCANDateProcessed = $aTCANDateProcessed;
        return $this;
    }
    /**
     * Get TicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketType()
    {
        return isset($this->TicketType) ? $this->TicketType : null;
    }
    /**
     * Set TicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketType
     * @return \StructType\Payment
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: string
        if (!is_null($ticketType) && !is_string($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketType, true), gettype($ticketType)), __LINE__);
        }
        if (is_null($ticketType) || (is_array($ticketType) && empty($ticketType))) {
            unset($this->TicketType);
        } else {
            $this->TicketType = $ticketType;
        }
        return $this;
    }
    /**
     * Get GcxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGcxID()
    {
        return isset($this->GcxID) ? $this->GcxID : null;
    }
    /**
     * Set GcxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gcxID
     * @return \StructType\Payment
     */
    public function setGcxID($gcxID = null)
    {
        // validation for constraint: string
        if (!is_null($gcxID) && !is_string($gcxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gcxID, true), gettype($gcxID)), __LINE__);
        }
        if (is_null($gcxID) || (is_array($gcxID) && empty($gcxID))) {
            unset($this->GcxID);
        } else {
            $this->GcxID = $gcxID;
        }
        return $this;
    }
    /**
     * Get GcxOptOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGcxOptOption()
    {
        return isset($this->GcxOptOption) ? $this->GcxOptOption : null;
    }
    /**
     * Set GcxOptOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gcxOptOption
     * @return \StructType\Payment
     */
    public function setGcxOptOption($gcxOptOption = null)
    {
        // validation for constraint: string
        if (!is_null($gcxOptOption) && !is_string($gcxOptOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gcxOptOption, true), gettype($gcxOptOption)), __LINE__);
        }
        if (is_null($gcxOptOption) || (is_array($gcxOptOption) && empty($gcxOptOption))) {
            unset($this->GcxOptOption);
        } else {
            $this->GcxOptOption = $gcxOptOption;
        }
        return $this;
    }
    /**
     * Get GcxExported value
     * @return int|null
     */
    public function getGcxExported()
    {
        return $this->GcxExported;
    }
    /**
     * Set GcxExported value
     * @param int $gcxExported
     * @return \StructType\Payment
     */
    public function setGcxExported($gcxExported = null)
    {
        // validation for constraint: int
        if (!is_null($gcxExported) && !(is_int($gcxExported) || ctype_digit($gcxExported))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gcxExported, true), gettype($gcxExported)), __LINE__);
        }
        $this->GcxExported = $gcxExported;
        return $this;
    }
    /**
     * Get GcxExportedDate value
     * @return string|null
     */
    public function getGcxExportedDate()
    {
        return $this->GcxExportedDate;
    }
    /**
     * Set GcxExportedDate value
     * @param string $gcxExportedDate
     * @return \StructType\Payment
     */
    public function setGcxExportedDate($gcxExportedDate = null)
    {
        // validation for constraint: string
        if (!is_null($gcxExportedDate) && !is_string($gcxExportedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gcxExportedDate, true), gettype($gcxExportedDate)), __LINE__);
        }
        $this->GcxExportedDate = $gcxExportedDate;
        return $this;
    }
    /**
     * Get OriginalCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalCurrency()
    {
        return isset($this->OriginalCurrency) ? $this->OriginalCurrency : null;
    }
    /**
     * Set OriginalCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalCurrency
     * @return \StructType\Payment
     */
    public function setOriginalCurrency($originalCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originalCurrency) && !is_string($originalCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalCurrency, true), gettype($originalCurrency)), __LINE__);
        }
        if (is_null($originalCurrency) || (is_array($originalCurrency) && empty($originalCurrency))) {
            unset($this->OriginalCurrency);
        } else {
            $this->OriginalCurrency = $originalCurrency;
        }
        return $this;
    }
    /**
     * Get OriginalAmount value
     * @return float|null
     */
    public function getOriginalAmount()
    {
        return $this->OriginalAmount;
    }
    /**
     * Set OriginalAmount value
     * @param float $originalAmount
     * @return \StructType\Payment
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($originalAmount) && !(is_float($originalAmount) || is_numeric($originalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalAmount, true), gettype($originalAmount)), __LINE__);
        }
        $this->OriginalAmount = $originalAmount;
        return $this;
    }
    /**
     * Get IATANum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATANum()
    {
        return isset($this->IATANum) ? $this->IATANum : null;
    }
    /**
     * Set IATANum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATANum
     * @return \StructType\Payment
     */
    public function setIATANum($iATANum = null)
    {
        // validation for constraint: string
        if (!is_null($iATANum) && !is_string($iATANum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANum, true), gettype($iATANum)), __LINE__);
        }
        if (is_null($iATANum) || (is_array($iATANum) && empty($iATANum))) {
            unset($this->IATANum);
        } else {
            $this->IATANum = $iATANum;
        }
        return $this;
    }
    /**
     * Get ProcessorID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessorID()
    {
        return isset($this->ProcessorID) ? $this->ProcessorID : null;
    }
    /**
     * Set ProcessorID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processorID
     * @return \StructType\Payment
     */
    public function setProcessorID($processorID = null)
    {
        // validation for constraint: string
        if (!is_null($processorID) && !is_string($processorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processorID, true), gettype($processorID)), __LINE__);
        }
        if (is_null($processorID) || (is_array($processorID) && empty($processorID))) {
            unset($this->ProcessorID);
        } else {
            $this->ProcessorID = $processorID;
        }
        return $this;
    }
    /**
     * Get MerchantID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantID()
    {
        return isset($this->MerchantID) ? $this->MerchantID : null;
    }
    /**
     * Set MerchantID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantID
     * @return \StructType\Payment
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        if (is_null($merchantID) || (is_array($merchantID) && empty($merchantID))) {
            unset($this->MerchantID);
        } else {
            $this->MerchantID = $merchantID;
        }
        return $this;
    }
    /**
     * Get ProcessorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessorName()
    {
        return isset($this->ProcessorName) ? $this->ProcessorName : null;
    }
    /**
     * Set ProcessorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processorName
     * @return \StructType\Payment
     */
    public function setProcessorName($processorName = null)
    {
        // validation for constraint: string
        if (!is_null($processorName) && !is_string($processorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processorName, true), gettype($processorName)), __LINE__);
        }
        if (is_null($processorName) || (is_array($processorName) && empty($processorName))) {
            unset($this->ProcessorName);
        } else {
            $this->ProcessorName = $processorName;
        }
        return $this;
    }
    /**
     * Get OriginalPaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalPaymentMethod()
    {
        return isset($this->OriginalPaymentMethod) ? $this->OriginalPaymentMethod : null;
    }
    /**
     * Set OriginalPaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalPaymentMethod
     * @return \StructType\Payment
     */
    public function setOriginalPaymentMethod($originalPaymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentMethod) && !is_string($originalPaymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentMethod, true), gettype($originalPaymentMethod)), __LINE__);
        }
        if (is_null($originalPaymentMethod) || (is_array($originalPaymentMethod) && empty($originalPaymentMethod))) {
            unset($this->OriginalPaymentMethod);
        } else {
            $this->OriginalPaymentMethod = $originalPaymentMethod;
        }
        return $this;
    }
    /**
     * Get TransactionStatus value
     * @return int|null
     */
    public function getTransactionStatus()
    {
        return $this->TransactionStatus;
    }
    /**
     * Set TransactionStatus value
     * @param int $transactionStatus
     * @return \StructType\Payment
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: int
        if (!is_null($transactionStatus) && !(is_int($transactionStatus) || ctype_digit($transactionStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionStatus, true), gettype($transactionStatus)), __LINE__);
        }
        $this->TransactionStatus = $transactionStatus;
        return $this;
    }
    /**
     * Get ResponseMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseMessage()
    {
        return isset($this->ResponseMessage) ? $this->ResponseMessage : null;
    }
    /**
     * Set ResponseMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseMessage
     * @return \StructType\Payment
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        if (is_null($responseMessage) || (is_array($responseMessage) && empty($responseMessage))) {
            unset($this->ResponseMessage);
        } else {
            $this->ResponseMessage = $responseMessage;
        }
        return $this;
    }
    /**
     * Get ResponseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseCode()
    {
        return isset($this->ResponseCode) ? $this->ResponseCode : null;
    }
    /**
     * Set ResponseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseCode
     * @return \StructType\Payment
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        if (is_null($responseCode) || (is_array($responseCode) && empty($responseCode))) {
            unset($this->ResponseCode);
        } else {
            $this->ResponseCode = $responseCode;
        }
        return $this;
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\Payment
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\Payment
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\Payment
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyName
     * @return \StructType\Payment
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \StructType\Payment
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Address2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress2()
    {
        return isset($this->Address2) ? $this->Address2 : null;
    }
    /**
     * Set Address2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address2
     * @return \StructType\Payment
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        if (is_null($address2) || (is_array($address2) && empty($address2))) {
            unset($this->Address2);
        } else {
            $this->Address2 = $address2;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\Payment
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\Payment
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get Postal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostal()
    {
        return isset($this->Postal) ? $this->Postal : null;
    }
    /**
     * Set Postal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postal
     * @return \StructType\Payment
     */
    public function setPostal($postal = null)
    {
        // validation for constraint: string
        if (!is_null($postal) && !is_string($postal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postal, true), gettype($postal)), __LINE__);
        }
        if (is_null($postal) || (is_array($postal) && empty($postal))) {
            unset($this->Postal);
        } else {
            $this->Postal = $postal;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \StructType\Payment
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \StructType\Payment
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get DatePaid value
     * @return string|null
     */
    public function getDatePaid()
    {
        return $this->DatePaid;
    }
    /**
     * Set DatePaid value
     * @param string $datePaid
     * @return \StructType\Payment
     */
    public function setDatePaid($datePaid = null)
    {
        // validation for constraint: string
        if (!is_null($datePaid) && !is_string($datePaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePaid, true), gettype($datePaid)), __LINE__);
        }
        $this->DatePaid = $datePaid;
        return $this;
    }
    /**
     * Get UserData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserData()
    {
        return isset($this->UserData) ? $this->UserData : null;
    }
    /**
     * Set UserData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userData
     * @return \StructType\Payment
     */
    public function setUserData($userData = null)
    {
        // validation for constraint: string
        if (!is_null($userData) && !is_string($userData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userData, true), gettype($userData)), __LINE__);
        }
        if (is_null($userData) || (is_array($userData) && empty($userData))) {
            unset($this->UserData);
        } else {
            $this->UserData = $userData;
        }
        return $this;
    }
    /**
     * Get CardVerification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardVerification()
    {
        return isset($this->CardVerification) ? $this->CardVerification : null;
    }
    /**
     * Set CardVerification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardVerification
     * @return \StructType\Payment
     */
    public function setCardVerification($cardVerification = null)
    {
        // validation for constraint: string
        if (!is_null($cardVerification) && !is_string($cardVerification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardVerification, true), gettype($cardVerification)), __LINE__);
        }
        if (is_null($cardVerification) || (is_array($cardVerification) && empty($cardVerification))) {
            unset($this->CardVerification);
        } else {
            $this->CardVerification = $cardVerification;
        }
        return $this;
    }
    /**
     * Get GrossAmtResCurrency value
     * @return float|null
     */
    public function getGrossAmtResCurrency()
    {
        return $this->GrossAmtResCurrency;
    }
    /**
     * Set GrossAmtResCurrency value
     * @param float $grossAmtResCurrency
     * @return \StructType\Payment
     */
    public function setGrossAmtResCurrency($grossAmtResCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmtResCurrency) && !(is_float($grossAmtResCurrency) || is_numeric($grossAmtResCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmtResCurrency, true), gettype($grossAmtResCurrency)), __LINE__);
        }
        $this->GrossAmtResCurrency = $grossAmtResCurrency;
        return $this;
    }
    /**
     * Get GrossAmtPayCurrency value
     * @return float|null
     */
    public function getGrossAmtPayCurrency()
    {
        return $this->GrossAmtPayCurrency;
    }
    /**
     * Set GrossAmtPayCurrency value
     * @param float $grossAmtPayCurrency
     * @return \StructType\Payment
     */
    public function setGrossAmtPayCurrency($grossAmtPayCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmtPayCurrency) && !(is_float($grossAmtPayCurrency) || is_numeric($grossAmtPayCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmtPayCurrency, true), gettype($grossAmtPayCurrency)), __LINE__);
        }
        $this->GrossAmtPayCurrency = $grossAmtPayCurrency;
        return $this;
    }
    /**
     * Get NetAmtResCurrency value
     * @return float|null
     */
    public function getNetAmtResCurrency()
    {
        return $this->NetAmtResCurrency;
    }
    /**
     * Set NetAmtResCurrency value
     * @param float $netAmtResCurrency
     * @return \StructType\Payment
     */
    public function setNetAmtResCurrency($netAmtResCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($netAmtResCurrency) && !(is_float($netAmtResCurrency) || is_numeric($netAmtResCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netAmtResCurrency, true), gettype($netAmtResCurrency)), __LINE__);
        }
        $this->NetAmtResCurrency = $netAmtResCurrency;
        return $this;
    }
    /**
     * Get CommissionDeductedResCurrency value
     * @return float|null
     */
    public function getCommissionDeductedResCurrency()
    {
        return $this->CommissionDeductedResCurrency;
    }
    /**
     * Set CommissionDeductedResCurrency value
     * @param float $commissionDeductedResCurrency
     * @return \StructType\Payment
     */
    public function setCommissionDeductedResCurrency($commissionDeductedResCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($commissionDeductedResCurrency) && !(is_float($commissionDeductedResCurrency) || is_numeric($commissionDeductedResCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionDeductedResCurrency, true), gettype($commissionDeductedResCurrency)), __LINE__);
        }
        $this->CommissionDeductedResCurrency = $commissionDeductedResCurrency;
        return $this;
    }
    /**
     * Get CommissionDeductedPayCurrency value
     * @return float|null
     */
    public function getCommissionDeductedPayCurrency()
    {
        return $this->CommissionDeductedPayCurrency;
    }
    /**
     * Set CommissionDeductedPayCurrency value
     * @param float $commissionDeductedPayCurrency
     * @return \StructType\Payment
     */
    public function setCommissionDeductedPayCurrency($commissionDeductedPayCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($commissionDeductedPayCurrency) && !(is_float($commissionDeductedPayCurrency) || is_numeric($commissionDeductedPayCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionDeductedPayCurrency, true), gettype($commissionDeductedPayCurrency)), __LINE__);
        }
        $this->CommissionDeductedPayCurrency = $commissionDeductedPayCurrency;
        return $this;
    }
    /**
     * Get RptNetFrmResCurrency value
     * @return float|null
     */
    public function getRptNetFrmResCurrency()
    {
        return $this->RptNetFrmResCurrency;
    }
    /**
     * Set RptNetFrmResCurrency value
     * @param float $rptNetFrmResCurrency
     * @return \StructType\Payment
     */
    public function setRptNetFrmResCurrency($rptNetFrmResCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($rptNetFrmResCurrency) && !(is_float($rptNetFrmResCurrency) || is_numeric($rptNetFrmResCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rptNetFrmResCurrency, true), gettype($rptNetFrmResCurrency)), __LINE__);
        }
        $this->RptNetFrmResCurrency = $rptNetFrmResCurrency;
        return $this;
    }
    /**
     * Get RptCommissionFromResCurrency value
     * @return float|null
     */
    public function getRptCommissionFromResCurrency()
    {
        return $this->RptCommissionFromResCurrency;
    }
    /**
     * Set RptCommissionFromResCurrency value
     * @param float $rptCommissionFromResCurrency
     * @return \StructType\Payment
     */
    public function setRptCommissionFromResCurrency($rptCommissionFromResCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($rptCommissionFromResCurrency) && !(is_float($rptCommissionFromResCurrency) || is_numeric($rptCommissionFromResCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rptCommissionFromResCurrency, true), gettype($rptCommissionFromResCurrency)), __LINE__);
        }
        $this->RptCommissionFromResCurrency = $rptCommissionFromResCurrency;
        return $this;
    }
    /**
     * Get RptCommissionFromPayCurrency value
     * @return float|null
     */
    public function getRptCommissionFromPayCurrency()
    {
        return $this->RptCommissionFromPayCurrency;
    }
    /**
     * Set RptCommissionFromPayCurrency value
     * @param float $rptCommissionFromPayCurrency
     * @return \StructType\Payment
     */
    public function setRptCommissionFromPayCurrency($rptCommissionFromPayCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($rptCommissionFromPayCurrency) && !(is_float($rptCommissionFromPayCurrency) || is_numeric($rptCommissionFromPayCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rptCommissionFromPayCurrency, true), gettype($rptCommissionFromPayCurrency)), __LINE__);
        }
        $this->RptCommissionFromPayCurrency = $rptCommissionFromPayCurrency;
        return $this;
    }
    /**
     * Get TotalRefundResCurrency value
     * @return float|null
     */
    public function getTotalRefundResCurrency()
    {
        return $this->TotalRefundResCurrency;
    }
    /**
     * Set TotalRefundResCurrency value
     * @param float $totalRefundResCurrency
     * @return \StructType\Payment
     */
    public function setTotalRefundResCurrency($totalRefundResCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($totalRefundResCurrency) && !(is_float($totalRefundResCurrency) || is_numeric($totalRefundResCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalRefundResCurrency, true), gettype($totalRefundResCurrency)), __LINE__);
        }
        $this->TotalRefundResCurrency = $totalRefundResCurrency;
        return $this;
    }
    /**
     * Get TotalRefundRptCurrency value
     * @return float|null
     */
    public function getTotalRefundRptCurrency()
    {
        return $this->TotalRefundRptCurrency;
    }
    /**
     * Set TotalRefundRptCurrency value
     * @param float $totalRefundRptCurrency
     * @return \StructType\Payment
     */
    public function setTotalRefundRptCurrency($totalRefundRptCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($totalRefundRptCurrency) && !(is_float($totalRefundRptCurrency) || is_numeric($totalRefundRptCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalRefundRptCurrency, true), gettype($totalRefundRptCurrency)), __LINE__);
        }
        $this->TotalRefundRptCurrency = $totalRefundRptCurrency;
        return $this;
    }
    /**
     * Get TotalRefundPayCurrency value
     * @return float|null
     */
    public function getTotalRefundPayCurrency()
    {
        return $this->TotalRefundPayCurrency;
    }
    /**
     * Set TotalRefundPayCurrency value
     * @param float $totalRefundPayCurrency
     * @return \StructType\Payment
     */
    public function setTotalRefundPayCurrency($totalRefundPayCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($totalRefundPayCurrency) && !(is_float($totalRefundPayCurrency) || is_numeric($totalRefundPayCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalRefundPayCurrency, true), gettype($totalRefundPayCurrency)), __LINE__);
        }
        $this->TotalRefundPayCurrency = $totalRefundPayCurrency;
        return $this;
    }
    /**
     * Get RedeemedVoucherAmount value
     * @return float|null
     */
    public function getRedeemedVoucherAmount()
    {
        return $this->RedeemedVoucherAmount;
    }
    /**
     * Set RedeemedVoucherAmount value
     * @param float $redeemedVoucherAmount
     * @return \StructType\Payment
     */
    public function setRedeemedVoucherAmount($redeemedVoucherAmount = null)
    {
        // validation for constraint: float
        if (!is_null($redeemedVoucherAmount) && !(is_float($redeemedVoucherAmount) || is_numeric($redeemedVoucherAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($redeemedVoucherAmount, true), gettype($redeemedVoucherAmount)), __LINE__);
        }
        $this->RedeemedVoucherAmount = $redeemedVoucherAmount;
        return $this;
    }
    /**
     * Get UserID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserID()
    {
        return isset($this->UserID) ? $this->UserID : null;
    }
    /**
     * Set UserID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userID
     * @return \StructType\Payment
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        if (is_null($userID) || (is_array($userID) && empty($userID))) {
            unset($this->UserID);
        } else {
            $this->UserID = $userID;
        }
        return $this;
    }
    /**
     * Get OriginalPaymentID value
     * @return int|null
     */
    public function getOriginalPaymentID()
    {
        return $this->OriginalPaymentID;
    }
    /**
     * Set OriginalPaymentID value
     * @param int $originalPaymentID
     * @return \StructType\Payment
     */
    public function setOriginalPaymentID($originalPaymentID = null)
    {
        // validation for constraint: int
        if (!is_null($originalPaymentID) && !(is_int($originalPaymentID) || ctype_digit($originalPaymentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalPaymentID, true), gettype($originalPaymentID)), __LINE__);
        }
        $this->OriginalPaymentID = $originalPaymentID;
        return $this;
    }
    /**
     * Get PaymentReservationChannelID value
     * @return int|null
     */
    public function getPaymentReservationChannelID()
    {
        return $this->PaymentReservationChannelID;
    }
    /**
     * Set PaymentReservationChannelID value
     * @param int $paymentReservationChannelID
     * @return \StructType\Payment
     */
    public function setPaymentReservationChannelID($paymentReservationChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentReservationChannelID) && !(is_int($paymentReservationChannelID) || ctype_digit($paymentReservationChannelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentReservationChannelID, true), gettype($paymentReservationChannelID)), __LINE__);
        }
        $this->PaymentReservationChannelID = $paymentReservationChannelID;
        return $this;
    }
    /**
     * Get AncillaryData01 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAncillaryData01()
    {
        return isset($this->AncillaryData01) ? $this->AncillaryData01 : null;
    }
    /**
     * Set AncillaryData01 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ancillaryData01
     * @return \StructType\Payment
     */
    public function setAncillaryData01($ancillaryData01 = null)
    {
        // validation for constraint: string
        if (!is_null($ancillaryData01) && !is_string($ancillaryData01)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ancillaryData01, true), gettype($ancillaryData01)), __LINE__);
        }
        if (is_null($ancillaryData01) || (is_array($ancillaryData01) && empty($ancillaryData01))) {
            unset($this->AncillaryData01);
        } else {
            $this->AncillaryData01 = $ancillaryData01;
        }
        return $this;
    }
    /**
     * Get AncillaryData02 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAncillaryData02()
    {
        return isset($this->AncillaryData02) ? $this->AncillaryData02 : null;
    }
    /**
     * Set AncillaryData02 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ancillaryData02
     * @return \StructType\Payment
     */
    public function setAncillaryData02($ancillaryData02 = null)
    {
        // validation for constraint: string
        if (!is_null($ancillaryData02) && !is_string($ancillaryData02)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ancillaryData02, true), gettype($ancillaryData02)), __LINE__);
        }
        if (is_null($ancillaryData02) || (is_array($ancillaryData02) && empty($ancillaryData02))) {
            unset($this->AncillaryData02);
        } else {
            $this->AncillaryData02 = $ancillaryData02;
        }
        return $this;
    }
    /**
     * Get AncillaryData03 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAncillaryData03()
    {
        return isset($this->AncillaryData03) ? $this->AncillaryData03 : null;
    }
    /**
     * Set AncillaryData03 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ancillaryData03
     * @return \StructType\Payment
     */
    public function setAncillaryData03($ancillaryData03 = null)
    {
        // validation for constraint: string
        if (!is_null($ancillaryData03) && !is_string($ancillaryData03)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ancillaryData03, true), gettype($ancillaryData03)), __LINE__);
        }
        if (is_null($ancillaryData03) || (is_array($ancillaryData03) && empty($ancillaryData03))) {
            unset($this->AncillaryData03);
        } else {
            $this->AncillaryData03 = $ancillaryData03;
        }
        return $this;
    }
    /**
     * Get AncillaryData04 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAncillaryData04()
    {
        return isset($this->AncillaryData04) ? $this->AncillaryData04 : null;
    }
    /**
     * Set AncillaryData04 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ancillaryData04
     * @return \StructType\Payment
     */
    public function setAncillaryData04($ancillaryData04 = null)
    {
        // validation for constraint: string
        if (!is_null($ancillaryData04) && !is_string($ancillaryData04)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ancillaryData04, true), gettype($ancillaryData04)), __LINE__);
        }
        if (is_null($ancillaryData04) || (is_array($ancillaryData04) && empty($ancillaryData04))) {
            unset($this->AncillaryData04);
        } else {
            $this->AncillaryData04 = $ancillaryData04;
        }
        return $this;
    }
    /**
     * Get AncillaryData05 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAncillaryData05()
    {
        return isset($this->AncillaryData05) ? $this->AncillaryData05 : null;
    }
    /**
     * Set AncillaryData05 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ancillaryData05
     * @return \StructType\Payment
     */
    public function setAncillaryData05($ancillaryData05 = null)
    {
        // validation for constraint: string
        if (!is_null($ancillaryData05) && !is_string($ancillaryData05)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ancillaryData05, true), gettype($ancillaryData05)), __LINE__);
        }
        if (is_null($ancillaryData05) || (is_array($ancillaryData05) && empty($ancillaryData05))) {
            unset($this->AncillaryData05);
        } else {
            $this->AncillaryData05 = $ancillaryData05;
        }
        return $this;
    }
    /**
     * Get MetaData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPaymentMetaData|null
     */
    public function getMetaData()
    {
        return isset($this->MetaData) ? $this->MetaData : null;
    }
    /**
     * Set MetaData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPaymentMetaData $metaData
     * @return \StructType\Payment
     */
    public function setMetaData(\ArrayType\ArrayOfPaymentMetaData $metaData = null)
    {
        if (is_null($metaData) || (is_array($metaData) && empty($metaData))) {
            unset($this->MetaData);
        } else {
            $this->MetaData = $metaData;
        }
        return $this;
    }
}
