<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfViewServiceInformation ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfViewServiceInformation
 * @subpackage Arrays
 */
class ArrayOfViewServiceInformation extends AbstractStructArrayBase
{
    /**
     * The ViewServiceInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ViewServiceInformation[]
     */
    public $ViewServiceInformation;
    /**
     * Constructor method for ArrayOfViewServiceInformation
     * @uses ArrayOfViewServiceInformation::setViewServiceInformation()
     * @param \StructType\ViewServiceInformation[] $viewServiceInformation
     */
    public function __construct(array $viewServiceInformation = array())
    {
        $this
            ->setViewServiceInformation($viewServiceInformation);
    }
    /**
     * Get ViewServiceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ViewServiceInformation[]|null
     */
    public function getViewServiceInformation()
    {
        return isset($this->ViewServiceInformation) ? $this->ViewServiceInformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setViewServiceInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setViewServiceInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateViewServiceInformationForArrayConstraintsFromSetViewServiceInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfViewServiceInformationViewServiceInformationItem) {
            // validation for constraint: itemType
            if (!$arrayOfViewServiceInformationViewServiceInformationItem instanceof \StructType\ViewServiceInformation) {
                $invalidValues[] = is_object($arrayOfViewServiceInformationViewServiceInformationItem) ? get_class($arrayOfViewServiceInformationViewServiceInformationItem) : sprintf('%s(%s)', gettype($arrayOfViewServiceInformationViewServiceInformationItem), var_export($arrayOfViewServiceInformationViewServiceInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ViewServiceInformation property can only contain items of type \StructType\ViewServiceInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ViewServiceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ViewServiceInformation[] $viewServiceInformation
     * @return \ArrayType\ArrayOfViewServiceInformation
     */
    public function setViewServiceInformation(array $viewServiceInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($viewServiceInformationArrayErrorMessage = self::validateViewServiceInformationForArrayConstraintsFromSetViewServiceInformation($viewServiceInformation))) {
            throw new \InvalidArgumentException($viewServiceInformationArrayErrorMessage, __LINE__);
        }
        if (is_null($viewServiceInformation) || (is_array($viewServiceInformation) && empty($viewServiceInformation))) {
            unset($this->ViewServiceInformation);
        } else {
            $this->ViewServiceInformation = $viewServiceInformation;
        }
        return $this;
    }
    /**
     * Add item to ViewServiceInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\ViewServiceInformation $item
     * @return \ArrayType\ArrayOfViewServiceInformation
     */
    public function addToViewServiceInformation(\StructType\ViewServiceInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ViewServiceInformation) {
            throw new \InvalidArgumentException(sprintf('The ViewServiceInformation property can only contain items of type \StructType\ViewServiceInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ViewServiceInformation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ViewServiceInformation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ViewServiceInformation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ViewServiceInformation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ViewServiceInformation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ViewServiceInformation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ViewServiceInformation
     */
    public function getAttributeName()
    {
        return 'ViewServiceInformation';
    }
}
