<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfHistory ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfHistory
 * @subpackage Arrays
 */
class ArrayOfHistory extends AbstractStructArrayBase
{
    /**
     * The History
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\History[]
     */
    public $History;
    /**
     * Constructor method for ArrayOfHistory
     * @uses ArrayOfHistory::setHistory()
     * @param \StructType\History[] $history
     */
    public function __construct(array $history = array())
    {
        $this
            ->setHistory($history);
    }
    /**
     * Get History value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\History[]|null
     */
    public function getHistory()
    {
        return isset($this->History) ? $this->History : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHistory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHistory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHistoryForArrayConstraintsFromSetHistory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfHistoryHistoryItem) {
            // validation for constraint: itemType
            if (!$arrayOfHistoryHistoryItem instanceof \StructType\History) {
                $invalidValues[] = is_object($arrayOfHistoryHistoryItem) ? get_class($arrayOfHistoryHistoryItem) : sprintf('%s(%s)', gettype($arrayOfHistoryHistoryItem), var_export($arrayOfHistoryHistoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The History property can only contain items of type \StructType\History, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set History value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\History[] $history
     * @return \ArrayType\ArrayOfHistory
     */
    public function setHistory(array $history = array())
    {
        // validation for constraint: array
        if ('' !== ($historyArrayErrorMessage = self::validateHistoryForArrayConstraintsFromSetHistory($history))) {
            throw new \InvalidArgumentException($historyArrayErrorMessage, __LINE__);
        }
        if (is_null($history) || (is_array($history) && empty($history))) {
            unset($this->History);
        } else {
            $this->History = $history;
        }
        return $this;
    }
    /**
     * Add item to History value
     * @throws \InvalidArgumentException
     * @param \StructType\History $item
     * @return \ArrayType\ArrayOfHistory
     */
    public function addToHistory(\StructType\History $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\History) {
            throw new \InvalidArgumentException(sprintf('The History property can only contain items of type \StructType\History, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->History[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\History|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\History|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\History|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\History|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\History|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string History
     */
    public function getAttributeName()
    {
        return 'History';
    }
}
