<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAirline ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAirline
 * @subpackage Arrays
 */
class ArrayOfAirline extends AbstractStructArrayBase
{
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Airline[]
     */
    public $Airline;
    /**
     * Constructor method for ArrayOfAirline
     * @uses ArrayOfAirline::setAirline()
     * @param \StructType\Airline[] $airline
     */
    public function __construct(array $airline = array())
    {
        $this
            ->setAirline($airline);
    }
    /**
     * Get Airline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Airline[]|null
     */
    public function getAirline()
    {
        return isset($this->Airline) ? $this->Airline : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAirline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineForArrayConstraintsFromSetAirline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAirlineAirlineItem) {
            // validation for constraint: itemType
            if (!$arrayOfAirlineAirlineItem instanceof \StructType\Airline) {
                $invalidValues[] = is_object($arrayOfAirlineAirlineItem) ? get_class($arrayOfAirlineAirlineItem) : sprintf('%s(%s)', gettype($arrayOfAirlineAirlineItem), var_export($arrayOfAirlineAirlineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airline property can only contain items of type \StructType\Airline, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Airline[] $airline
     * @return \ArrayType\ArrayOfAirline
     */
    public function setAirline(array $airline = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineArrayErrorMessage = self::validateAirlineForArrayConstraintsFromSetAirline($airline))) {
            throw new \InvalidArgumentException($airlineArrayErrorMessage, __LINE__);
        }
        if (is_null($airline) || (is_array($airline) && empty($airline))) {
            unset($this->Airline);
        } else {
            $this->Airline = $airline;
        }
        return $this;
    }
    /**
     * Add item to Airline value
     * @throws \InvalidArgumentException
     * @param \StructType\Airline $item
     * @return \ArrayType\ArrayOfAirline
     */
    public function addToAirline(\StructType\Airline $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Airline) {
            throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of type \StructType\Airline, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airline[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Airline|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Airline|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Airline|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Airline|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Airline|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Airline
     */
    public function getAttributeName()
    {
        return 'Airline';
    }
}
