<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewPNRBookingAgent StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewPNRBookingAgent
 * @subpackage Structs
 */
class ViewPNRBookingAgent extends AbstractStructBase
{
    /**
     * The BookingAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingAgent;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ViewPNRBookingAgent
     * @uses ViewPNRBookingAgent::setBookingAgent()
     * @uses ViewPNRBookingAgent::setExceptions()
     * @param string $bookingAgent
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct($bookingAgent = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setBookingAgent($bookingAgent)
            ->setExceptions($exceptions);
    }
    /**
     * Get BookingAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingAgent()
    {
        return isset($this->BookingAgent) ? $this->BookingAgent : null;
    }
    /**
     * Set BookingAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingAgent
     * @return \StructType\ViewPNRBookingAgent
     */
    public function setBookingAgent($bookingAgent = null)
    {
        // validation for constraint: string
        if (!is_null($bookingAgent) && !is_string($bookingAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingAgent, true), gettype($bookingAgent)), __LINE__);
        }
        if (is_null($bookingAgent) || (is_array($bookingAgent) && empty($bookingAgent))) {
            unset($this->BookingAgent);
        } else {
            $this->BookingAgent = $bookingAgent;
        }
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewPNRBookingAgent
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
