<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrievePNRBookingAgent StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrievePNRBookingAgent
 * @subpackage Structs
 */
class RetrievePNRBookingAgent extends TransactionInfo
{
    /**
     * The RetrievePNRBookingAgentRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrievePNRBookingAgent
     */
    public $RetrievePNRBookingAgentRequest;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * Constructor method for RetrievePNRBookingAgent
     * @uses RetrievePNRBookingAgent::setRetrievePNRBookingAgentRequest()
     * @uses RetrievePNRBookingAgent::setReservationInfo()
     * @param \StructType\RetrievePNRBookingAgent $retrievePNRBookingAgentRequest
     * @param \StructType\ReservationInfo $reservationInfo
     */
    public function __construct(\StructType\RetrievePNRBookingAgent $retrievePNRBookingAgentRequest = null, \StructType\ReservationInfo $reservationInfo = null)
    {
        $this
            ->setRetrievePNRBookingAgentRequest($retrievePNRBookingAgentRequest)
            ->setReservationInfo($reservationInfo);
    }
    /**
     * Get RetrievePNRBookingAgentRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrievePNRBookingAgent|null
     */
    public function getRetrievePNRBookingAgentRequest()
    {
        return isset($this->RetrievePNRBookingAgentRequest) ? $this->RetrievePNRBookingAgentRequest : null;
    }
    /**
     * Set RetrievePNRBookingAgentRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrievePNRBookingAgent $retrievePNRBookingAgentRequest
     * @return \StructType\RetrievePNRBookingAgent
     */
    public function setRetrievePNRBookingAgentRequest(\StructType\RetrievePNRBookingAgent $retrievePNRBookingAgentRequest = null)
    {
        if (is_null($retrievePNRBookingAgentRequest) || (is_array($retrievePNRBookingAgentRequest) && empty($retrievePNRBookingAgentRequest))) {
            unset($this->RetrievePNRBookingAgentRequest);
        } else {
            $this->RetrievePNRBookingAgentRequest = $retrievePNRBookingAgentRequest;
        }
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\RetrievePNRBookingAgent
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
}
