<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearServiceCache StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClearServiceCache
 * @subpackage Structs
 */
class ClearServiceCache extends TransactionInfo
{
    /**
     * The ClearServiceCacheRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClearServiceCache
     */
    public $ClearServiceCacheRequest;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Status;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ClearServiceCache
     * @uses ClearServiceCache::setClearServiceCacheRequest()
     * @uses ClearServiceCache::setStatus()
     * @uses ClearServiceCache::setExceptions()
     * @param \StructType\ClearServiceCache $clearServiceCacheRequest
     * @param bool $status
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\ClearServiceCache $clearServiceCacheRequest = null, $status = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setClearServiceCacheRequest($clearServiceCacheRequest)
            ->setStatus($status)
            ->setExceptions($exceptions);
    }
    /**
     * Get ClearServiceCacheRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClearServiceCache|null
     */
    public function getClearServiceCacheRequest()
    {
        return isset($this->ClearServiceCacheRequest) ? $this->ClearServiceCacheRequest : null;
    }
    /**
     * Set ClearServiceCacheRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ClearServiceCache $clearServiceCacheRequest
     * @return \StructType\ClearServiceCache
     */
    public function setClearServiceCacheRequest(\StructType\ClearServiceCache $clearServiceCacheRequest = null)
    {
        if (is_null($clearServiceCacheRequest) || (is_array($clearServiceCacheRequest) && empty($clearServiceCacheRequest))) {
            unset($this->ClearServiceCacheRequest);
        } else {
            $this->ClearServiceCacheRequest = $clearServiceCacheRequest;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\ClearServiceCache
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ClearServiceCache
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
