<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Clear ServiceType
 * @subpackage Services
 */
class Clear extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ClearServiceCache
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ClearServiceCache $parameters
     * @return \StructType\ClearServiceCacheResponse|bool
     */
    public function ClearServiceCache(\StructType\ClearServiceCache $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ClearServiceCache($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ClearServiceCacheResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
