<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateUser StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateUser
 * @subpackage Structs
 */
class ValidateUser extends AbstractStructBase
{
    /**
     * The ValidateUserRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticateUser
     */
    public $ValidateUserRequest;
    /**
     * The AuthenticateUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticateUser
     */
    public $AuthenticateUser;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Balance;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ValidateUser
     * @uses ValidateUser::setValidateUserRequest()
     * @uses ValidateUser::setAuthenticateUser()
     * @uses ValidateUser::setBalance()
     * @uses ValidateUser::setExceptions()
     * @param \StructType\AuthenticateUser $validateUserRequest
     * @param \StructType\AuthenticateUser $authenticateUser
     * @param float $balance
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\AuthenticateUser $validateUserRequest = null, \StructType\AuthenticateUser $authenticateUser = null, $balance = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setValidateUserRequest($validateUserRequest)
            ->setAuthenticateUser($authenticateUser)
            ->setBalance($balance)
            ->setExceptions($exceptions);
    }
    /**
     * Get ValidateUserRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticateUser|null
     */
    public function getValidateUserRequest()
    {
        return isset($this->ValidateUserRequest) ? $this->ValidateUserRequest : null;
    }
    /**
     * Set ValidateUserRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticateUser $validateUserRequest
     * @return \StructType\ValidateUser
     */
    public function setValidateUserRequest(\StructType\AuthenticateUser $validateUserRequest = null)
    {
        if (is_null($validateUserRequest) || (is_array($validateUserRequest) && empty($validateUserRequest))) {
            unset($this->ValidateUserRequest);
        } else {
            $this->ValidateUserRequest = $validateUserRequest;
        }
        return $this;
    }
    /**
     * Get AuthenticateUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticateUser|null
     */
    public function getAuthenticateUser()
    {
        return isset($this->AuthenticateUser) ? $this->AuthenticateUser : null;
    }
    /**
     * Set AuthenticateUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticateUser $authenticateUser
     * @return \StructType\ValidateUser
     */
    public function setAuthenticateUser(\StructType\AuthenticateUser $authenticateUser = null)
    {
        if (is_null($authenticateUser) || (is_array($authenticateUser) && empty($authenticateUser))) {
            unset($this->AuthenticateUser);
        } else {
            $this->AuthenticateUser = $authenticateUser;
        }
        return $this;
    }
    /**
     * Get Balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\ValidateUser
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get Exceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return isset($this->Exceptions) ? $this->Exceptions : null;
    }
    /**
     * Set Exceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ValidateUser
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        if (is_null($exceptions) || (is_array($exceptions) && empty($exceptions))) {
            unset($this->Exceptions);
        } else {
            $this->Exceptions = $exceptions;
        }
        return $this;
    }
}
