<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateUser.UserPrivilege StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthenticateUser.UserPrivilege
 * @subpackage Structs
 */
class AuthenticateUser_UserPrivilege extends AbstractStructBase
{
    /**
     * The UserPrivilegeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserPrivilegeName;
    /**
     * The UserPrivilegeLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UserPrivilegeLevel;
    /**
     * Constructor method for AuthenticateUser.UserPrivilege
     * @uses AuthenticateUser_UserPrivilege::setUserPrivilegeName()
     * @uses AuthenticateUser_UserPrivilege::setUserPrivilegeLevel()
     * @param string $userPrivilegeName
     * @param string $userPrivilegeLevel
     */
    public function __construct($userPrivilegeName = null, $userPrivilegeLevel = null)
    {
        $this
            ->setUserPrivilegeName($userPrivilegeName)
            ->setUserPrivilegeLevel($userPrivilegeLevel);
    }
    /**
     * Get UserPrivilegeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserPrivilegeName()
    {
        return isset($this->UserPrivilegeName) ? $this->UserPrivilegeName : null;
    }
    /**
     * Set UserPrivilegeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userPrivilegeName
     * @return \StructType\AuthenticateUser_UserPrivilege
     */
    public function setUserPrivilegeName($userPrivilegeName = null)
    {
        // validation for constraint: string
        if (!is_null($userPrivilegeName) && !is_string($userPrivilegeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userPrivilegeName, true), gettype($userPrivilegeName)), __LINE__);
        }
        if (is_null($userPrivilegeName) || (is_array($userPrivilegeName) && empty($userPrivilegeName))) {
            unset($this->UserPrivilegeName);
        } else {
            $this->UserPrivilegeName = $userPrivilegeName;
        }
        return $this;
    }
    /**
     * Get UserPrivilegeLevel value
     * @return string|null
     */
    public function getUserPrivilegeLevel()
    {
        return $this->UserPrivilegeLevel;
    }
    /**
     * Set UserPrivilegeLevel value
     * @uses \EnumType\Enumerations_PrivlegeLevel::valueIsValid()
     * @uses \EnumType\Enumerations_PrivlegeLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userPrivilegeLevel
     * @return \StructType\AuthenticateUser_UserPrivilege
     */
    public function setUserPrivilegeLevel($userPrivilegeLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_PrivlegeLevel::valueIsValid($userPrivilegeLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_PrivlegeLevel', is_array($userPrivilegeLevel) ? implode(', ', $userPrivilegeLevel) : var_export($userPrivilegeLevel, true), implode(', ', \EnumType\Enumerations_PrivlegeLevel::getValidValues())), __LINE__);
        }
        $this->UserPrivilegeLevel = $userPrivilegeLevel;
        return $this;
    }
}
