<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.users.svc?singleWSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.users.svc?singleWSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \ServiceType\Authenticate($options);
/**
 * Sample call for AuthenticateUser operation/method
 */
if ($authenticate->AuthenticateUser(new \StructType\AuthenticateUser()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for ChangeUserPassword operation/method
 */
if ($change->ChangeUserPassword(new \StructType\ChangeUserPassword()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Forgotten ServiceType
 */
$forgotten = new \ServiceType\Forgotten($options);
/**
 * Sample call for ForgottenUserPassword operation/method
 */
if ($forgotten->ForgottenUserPassword(new \StructType\ForgottenUserPassword()) !== false) {
    print_r($forgotten->getResult());
} else {
    print_r($forgotten->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckUserNameAvailability operation/method
 */
if ($check->CheckUserNameAvailability(new \StructType\CheckUserNameAvailability()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for ValidateUser operation/method
 */
if ($validate->ValidateUser(new \StructType\ValidateUser()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
