<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForgottenUserPassword StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ForgottenUserPassword
 * @subpackage Structs
 */
class ForgottenUserPassword extends TransactionInfo
{
    /**
     * The ForgottenUserPasswordRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ForgottenUserPassword
     */
    public $ForgottenUserPasswordRequest;
    /**
     * The LanguageCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LanguageCode;
    /**
     * The EmailAddressInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\EmailAddressInfo
     */
    public $EmailAddressInfo;
    /**
     * The UserNameInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\UserNameInfo
     */
    public $UserNameInfo;
    /**
     * The ActionSuccessful
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ActionSuccessful;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ForgottenUserPassword
     * @uses ForgottenUserPassword::setForgottenUserPasswordRequest()
     * @uses ForgottenUserPassword::setLanguageCode()
     * @uses ForgottenUserPassword::setEmailAddressInfo()
     * @uses ForgottenUserPassword::setUserNameInfo()
     * @uses ForgottenUserPassword::setActionSuccessful()
     * @uses ForgottenUserPassword::setExceptions()
     * @param \StructType\ForgottenUserPassword $forgottenUserPasswordRequest
     * @param string $languageCode
     * @param \StructType\EmailAddressInfo $emailAddressInfo
     * @param \StructType\UserNameInfo $userNameInfo
     * @param bool $actionSuccessful
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\ForgottenUserPassword $forgottenUserPasswordRequest = null, $languageCode = null, \StructType\EmailAddressInfo $emailAddressInfo = null, \StructType\UserNameInfo $userNameInfo = null, $actionSuccessful = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setForgottenUserPasswordRequest($forgottenUserPasswordRequest)
            ->setLanguageCode($languageCode)
            ->setEmailAddressInfo($emailAddressInfo)
            ->setUserNameInfo($userNameInfo)
            ->setActionSuccessful($actionSuccessful)
            ->setExceptions($exceptions);
    }
    /**
     * Get ForgottenUserPasswordRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ForgottenUserPassword|null
     */
    public function getForgottenUserPasswordRequest()
    {
        return isset($this->ForgottenUserPasswordRequest) ? $this->ForgottenUserPasswordRequest : null;
    }
    /**
     * Set ForgottenUserPasswordRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ForgottenUserPassword $forgottenUserPasswordRequest
     * @return \StructType\ForgottenUserPassword
     */
    public function setForgottenUserPasswordRequest(\StructType\ForgottenUserPassword $forgottenUserPasswordRequest = null)
    {
        if (is_null($forgottenUserPasswordRequest) || (is_array($forgottenUserPasswordRequest) && empty($forgottenUserPasswordRequest))) {
            unset($this->ForgottenUserPasswordRequest);
        } else {
            $this->ForgottenUserPasswordRequest = $forgottenUserPasswordRequest;
        }
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\ForgottenUserPassword
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get EmailAddressInfo value
     * @return \StructType\EmailAddressInfo|null
     */
    public function getEmailAddressInfo()
    {
        return $this->EmailAddressInfo;
    }
    /**
     * Set EmailAddressInfo value
     * @param \StructType\EmailAddressInfo $emailAddressInfo
     * @return \StructType\ForgottenUserPassword
     */
    public function setEmailAddressInfo(\StructType\EmailAddressInfo $emailAddressInfo = null)
    {
        $this->EmailAddressInfo = $emailAddressInfo;
        return $this;
    }
    /**
     * Get UserNameInfo value
     * @return \StructType\UserNameInfo|null
     */
    public function getUserNameInfo()
    {
        return $this->UserNameInfo;
    }
    /**
     * Set UserNameInfo value
     * @param \StructType\UserNameInfo $userNameInfo
     * @return \StructType\ForgottenUserPassword
     */
    public function setUserNameInfo(\StructType\UserNameInfo $userNameInfo = null)
    {
        $this->UserNameInfo = $userNameInfo;
        return $this;
    }
    /**
     * Get ActionSuccessful value
     * @return bool|null
     */
    public function getActionSuccessful()
    {
        return $this->ActionSuccessful;
    }
    /**
     * Set ActionSuccessful value
     * @param bool $actionSuccessful
     * @return \StructType\ForgottenUserPassword
     */
    public function setActionSuccessful($actionSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($actionSuccessful) && !is_bool($actionSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($actionSuccessful, true), gettype($actionSuccessful)), __LINE__);
        }
        $this->ActionSuccessful = $actionSuccessful;
        return $this;
    }
    /**
     * Get Exceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return isset($this->Exceptions) ? $this->Exceptions : null;
    }
    /**
     * Set Exceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ForgottenUserPassword
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        if (is_null($exceptions) || (is_array($exceptions) && empty($exceptions))) {
            unset($this->Exceptions);
        } else {
            $this->Exceptions = $exceptions;
        }
        return $this;
    }
}
