<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeUserPassword StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangeUserPassword
 * @subpackage Structs
 */
class ChangeUserPassword extends TransactionInfo
{
    /**
     * The ChangeUserPasswordRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ChangeUserPassword
     */
    public $ChangeUserPasswordRequest;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The CurrentPassword
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CurrentPassword;
    /**
     * The NewPassword
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $NewPassword;
    /**
     * The ResultCode
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultMessage
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ResultMessage;
    /**
     * The PasswordStrength
     * @var int
     */
    public $PasswordStrength;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserID;
    /**
     * The DaysUntilPasswordChange
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DaysUntilPasswordChange;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ChangeUserPassword
     * @uses ChangeUserPassword::setChangeUserPasswordRequest()
     * @uses ChangeUserPassword::setUserName()
     * @uses ChangeUserPassword::setCurrentPassword()
     * @uses ChangeUserPassword::setNewPassword()
     * @uses ChangeUserPassword::setResultCode()
     * @uses ChangeUserPassword::setResultMessage()
     * @uses ChangeUserPassword::setPasswordStrength()
     * @uses ChangeUserPassword::setUserID()
     * @uses ChangeUserPassword::setDaysUntilPasswordChange()
     * @uses ChangeUserPassword::setExceptions()
     * @param \StructType\ChangeUserPassword $changeUserPasswordRequest
     * @param string $userName
     * @param string $currentPassword
     * @param string $newPassword
     * @param string $resultCode
     * @param string $resultMessage
     * @param int $passwordStrength
     * @param string $userID
     * @param string $daysUntilPasswordChange
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\ChangeUserPassword $changeUserPasswordRequest = null, $userName = null, $currentPassword = null, $newPassword = null, $resultCode = null, $resultMessage = null, $passwordStrength = null, $userID = null, $daysUntilPasswordChange = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setChangeUserPasswordRequest($changeUserPasswordRequest)
            ->setUserName($userName)
            ->setCurrentPassword($currentPassword)
            ->setNewPassword($newPassword)
            ->setResultCode($resultCode)
            ->setResultMessage($resultMessage)
            ->setPasswordStrength($passwordStrength)
            ->setUserID($userID)
            ->setDaysUntilPasswordChange($daysUntilPasswordChange)
            ->setExceptions($exceptions);
    }
    /**
     * Get ChangeUserPasswordRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ChangeUserPassword|null
     */
    public function getChangeUserPasswordRequest()
    {
        return isset($this->ChangeUserPasswordRequest) ? $this->ChangeUserPasswordRequest : null;
    }
    /**
     * Set ChangeUserPasswordRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ChangeUserPassword $changeUserPasswordRequest
     * @return \StructType\ChangeUserPassword
     */
    public function setChangeUserPasswordRequest(\StructType\ChangeUserPassword $changeUserPasswordRequest = null)
    {
        if (is_null($changeUserPasswordRequest) || (is_array($changeUserPasswordRequest) && empty($changeUserPasswordRequest))) {
            unset($this->ChangeUserPasswordRequest);
        } else {
            $this->ChangeUserPasswordRequest = $changeUserPasswordRequest;
        }
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\ChangeUserPassword
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get CurrentPassword value
     * @return string|null
     */
    public function getCurrentPassword()
    {
        return $this->CurrentPassword;
    }
    /**
     * Set CurrentPassword value
     * @param string $currentPassword
     * @return \StructType\ChangeUserPassword
     */
    public function setCurrentPassword($currentPassword = null)
    {
        // validation for constraint: string
        if (!is_null($currentPassword) && !is_string($currentPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentPassword, true), gettype($currentPassword)), __LINE__);
        }
        $this->CurrentPassword = $currentPassword;
        return $this;
    }
    /**
     * Get NewPassword value
     * @return string|null
     */
    public function getNewPassword()
    {
        return $this->NewPassword;
    }
    /**
     * Set NewPassword value
     * @param string $newPassword
     * @return \StructType\ChangeUserPassword
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPassword, true), gettype($newPassword)), __LINE__);
        }
        $this->NewPassword = $newPassword;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @uses \EnumType\Enumerations_AuthenticationResponseCodes::valueIsValid()
     * @uses \EnumType\Enumerations_AuthenticationResponseCodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultCode
     * @return \StructType\ChangeUserPassword
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_AuthenticationResponseCodes::valueIsValid($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_AuthenticationResponseCodes', is_array($resultCode) ? implode(', ', $resultCode) : var_export($resultCode, true), implode(', ', \EnumType\Enumerations_AuthenticationResponseCodes::getValidValues())), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->ResultMessage;
    }
    /**
     * Set ResultMessage value
     * @param string $resultMessage
     * @return \StructType\ChangeUserPassword
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->ResultMessage = $resultMessage;
        return $this;
    }
    /**
     * Get PasswordStrength value
     * @return int|null
     */
    public function getPasswordStrength()
    {
        return $this->PasswordStrength;
    }
    /**
     * Set PasswordStrength value
     * @param int $passwordStrength
     * @return \StructType\ChangeUserPassword
     */
    public function setPasswordStrength($passwordStrength = null)
    {
        // validation for constraint: int
        if (!is_null($passwordStrength) && !(is_int($passwordStrength) || ctype_digit($passwordStrength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passwordStrength, true), gettype($passwordStrength)), __LINE__);
        }
        $this->PasswordStrength = $passwordStrength;
        return $this;
    }
    /**
     * Get UserID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\ChangeUserPassword
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get DaysUntilPasswordChange value
     * @return string|null
     */
    public function getDaysUntilPasswordChange()
    {
        return $this->DaysUntilPasswordChange;
    }
    /**
     * Set DaysUntilPasswordChange value
     * @param string $daysUntilPasswordChange
     * @return \StructType\ChangeUserPassword
     */
    public function setDaysUntilPasswordChange($daysUntilPasswordChange = null)
    {
        // validation for constraint: string
        if (!is_null($daysUntilPasswordChange) && !is_string($daysUntilPasswordChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daysUntilPasswordChange, true), gettype($daysUntilPasswordChange)), __LINE__);
        }
        $this->DaysUntilPasswordChange = $daysUntilPasswordChange;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ChangeUserPassword
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
