<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateUser.UserInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthenticateUser.UserInfo
 * @subpackage Structs
 */
class AuthenticateUser_UserInfo extends AbstractStructBase
{
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The AccessCallCenterFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AccessCallCenterFee;
    /**
     * The IsTrustedClientUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsTrustedClientUser;
    /**
     * The ReservationChannelIDToAlias
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservationChannelIDToAlias;
    /**
     * The ReservationChannelNameToAlias
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationChannelNameToAlias;
    /**
     * The DefaultUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultUserName;
    /**
     * The UserGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAuthenticateUser_UserGroup
     */
    public $UserGroups;
    /**
     * The UserPrivileges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAuthenticateUser_UserPrivilege
     */
    public $UserPrivileges;
    /**
     * Constructor method for AuthenticateUser.UserInfo
     * @uses AuthenticateUser_UserInfo::setUserName()
     * @uses AuthenticateUser_UserInfo::setAccessCallCenterFee()
     * @uses AuthenticateUser_UserInfo::setIsTrustedClientUser()
     * @uses AuthenticateUser_UserInfo::setReservationChannelIDToAlias()
     * @uses AuthenticateUser_UserInfo::setReservationChannelNameToAlias()
     * @uses AuthenticateUser_UserInfo::setDefaultUserName()
     * @uses AuthenticateUser_UserInfo::setUserGroups()
     * @uses AuthenticateUser_UserInfo::setUserPrivileges()
     * @param string $userName
     * @param bool $accessCallCenterFee
     * @param bool $isTrustedClientUser
     * @param int $reservationChannelIDToAlias
     * @param string $reservationChannelNameToAlias
     * @param string $defaultUserName
     * @param \ArrayType\ArrayOfAuthenticateUser_UserGroup $userGroups
     * @param \ArrayType\ArrayOfAuthenticateUser_UserPrivilege $userPrivileges
     */
    public function __construct($userName = null, $accessCallCenterFee = null, $isTrustedClientUser = null, $reservationChannelIDToAlias = null, $reservationChannelNameToAlias = null, $defaultUserName = null, \ArrayType\ArrayOfAuthenticateUser_UserGroup $userGroups = null, \ArrayType\ArrayOfAuthenticateUser_UserPrivilege $userPrivileges = null)
    {
        $this
            ->setUserName($userName)
            ->setAccessCallCenterFee($accessCallCenterFee)
            ->setIsTrustedClientUser($isTrustedClientUser)
            ->setReservationChannelIDToAlias($reservationChannelIDToAlias)
            ->setReservationChannelNameToAlias($reservationChannelNameToAlias)
            ->setDefaultUserName($defaultUserName)
            ->setUserGroups($userGroups)
            ->setUserPrivileges($userPrivileges);
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \StructType\AuthenticateUser_UserInfo
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get AccessCallCenterFee value
     * @return bool|null
     */
    public function getAccessCallCenterFee()
    {
        return $this->AccessCallCenterFee;
    }
    /**
     * Set AccessCallCenterFee value
     * @param bool $accessCallCenterFee
     * @return \StructType\AuthenticateUser_UserInfo
     */
    public function setAccessCallCenterFee($accessCallCenterFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($accessCallCenterFee) && !is_bool($accessCallCenterFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accessCallCenterFee, true), gettype($accessCallCenterFee)), __LINE__);
        }
        $this->AccessCallCenterFee = $accessCallCenterFee;
        return $this;
    }
    /**
     * Get IsTrustedClientUser value
     * @return bool|null
     */
    public function getIsTrustedClientUser()
    {
        return $this->IsTrustedClientUser;
    }
    /**
     * Set IsTrustedClientUser value
     * @param bool $isTrustedClientUser
     * @return \StructType\AuthenticateUser_UserInfo
     */
    public function setIsTrustedClientUser($isTrustedClientUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTrustedClientUser) && !is_bool($isTrustedClientUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTrustedClientUser, true), gettype($isTrustedClientUser)), __LINE__);
        }
        $this->IsTrustedClientUser = $isTrustedClientUser;
        return $this;
    }
    /**
     * Get ReservationChannelIDToAlias value
     * @return int|null
     */
    public function getReservationChannelIDToAlias()
    {
        return $this->ReservationChannelIDToAlias;
    }
    /**
     * Set ReservationChannelIDToAlias value
     * @param int $reservationChannelIDToAlias
     * @return \StructType\AuthenticateUser_UserInfo
     */
    public function setReservationChannelIDToAlias($reservationChannelIDToAlias = null)
    {
        // validation for constraint: int
        if (!is_null($reservationChannelIDToAlias) && !(is_int($reservationChannelIDToAlias) || ctype_digit($reservationChannelIDToAlias))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationChannelIDToAlias, true), gettype($reservationChannelIDToAlias)), __LINE__);
        }
        $this->ReservationChannelIDToAlias = $reservationChannelIDToAlias;
        return $this;
    }
    /**
     * Get ReservationChannelNameToAlias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationChannelNameToAlias()
    {
        return isset($this->ReservationChannelNameToAlias) ? $this->ReservationChannelNameToAlias : null;
    }
    /**
     * Set ReservationChannelNameToAlias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationChannelNameToAlias
     * @return \StructType\AuthenticateUser_UserInfo
     */
    public function setReservationChannelNameToAlias($reservationChannelNameToAlias = null)
    {
        // validation for constraint: string
        if (!is_null($reservationChannelNameToAlias) && !is_string($reservationChannelNameToAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationChannelNameToAlias, true), gettype($reservationChannelNameToAlias)), __LINE__);
        }
        if (is_null($reservationChannelNameToAlias) || (is_array($reservationChannelNameToAlias) && empty($reservationChannelNameToAlias))) {
            unset($this->ReservationChannelNameToAlias);
        } else {
            $this->ReservationChannelNameToAlias = $reservationChannelNameToAlias;
        }
        return $this;
    }
    /**
     * Get DefaultUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultUserName()
    {
        return isset($this->DefaultUserName) ? $this->DefaultUserName : null;
    }
    /**
     * Set DefaultUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultUserName
     * @return \StructType\AuthenticateUser_UserInfo
     */
    public function setDefaultUserName($defaultUserName = null)
    {
        // validation for constraint: string
        if (!is_null($defaultUserName) && !is_string($defaultUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultUserName, true), gettype($defaultUserName)), __LINE__);
        }
        if (is_null($defaultUserName) || (is_array($defaultUserName) && empty($defaultUserName))) {
            unset($this->DefaultUserName);
        } else {
            $this->DefaultUserName = $defaultUserName;
        }
        return $this;
    }
    /**
     * Get UserGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAuthenticateUser_UserGroup|null
     */
    public function getUserGroups()
    {
        return isset($this->UserGroups) ? $this->UserGroups : null;
    }
    /**
     * Set UserGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAuthenticateUser_UserGroup $userGroups
     * @return \StructType\AuthenticateUser_UserInfo
     */
    public function setUserGroups(\ArrayType\ArrayOfAuthenticateUser_UserGroup $userGroups = null)
    {
        if (is_null($userGroups) || (is_array($userGroups) && empty($userGroups))) {
            unset($this->UserGroups);
        } else {
            $this->UserGroups = $userGroups;
        }
        return $this;
    }
    /**
     * Get UserPrivileges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAuthenticateUser_UserPrivilege|null
     */
    public function getUserPrivileges()
    {
        return isset($this->UserPrivileges) ? $this->UserPrivileges : null;
    }
    /**
     * Set UserPrivileges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAuthenticateUser_UserPrivilege $userPrivileges
     * @return \StructType\AuthenticateUser_UserInfo
     */
    public function setUserPrivileges(\ArrayType\ArrayOfAuthenticateUser_UserPrivilege $userPrivileges = null)
    {
        if (is_null($userPrivileges) || (is_array($userPrivileges) && empty($userPrivileges))) {
            unset($this->UserPrivileges);
        } else {
            $this->UserPrivileges = $userPrivileges;
        }
        return $this;
    }
}
