<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateUser.GroupRight StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthenticateUser.GroupRight
 * @subpackage Structs
 */
class AuthenticateUser_GroupRight extends AbstractStructBase
{
    /**
     * The GroupPrivilegeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupPrivilegeName;
    /**
     * The GroupPrivilegeLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GroupPrivilegeLevel;
    /**
     * Constructor method for AuthenticateUser.GroupRight
     * @uses AuthenticateUser_GroupRight::setGroupPrivilegeName()
     * @uses AuthenticateUser_GroupRight::setGroupPrivilegeLevel()
     * @param string $groupPrivilegeName
     * @param string $groupPrivilegeLevel
     */
    public function __construct($groupPrivilegeName = null, $groupPrivilegeLevel = null)
    {
        $this
            ->setGroupPrivilegeName($groupPrivilegeName)
            ->setGroupPrivilegeLevel($groupPrivilegeLevel);
    }
    /**
     * Get GroupPrivilegeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupPrivilegeName()
    {
        return isset($this->GroupPrivilegeName) ? $this->GroupPrivilegeName : null;
    }
    /**
     * Set GroupPrivilegeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupPrivilegeName
     * @return \StructType\AuthenticateUser_GroupRight
     */
    public function setGroupPrivilegeName($groupPrivilegeName = null)
    {
        // validation for constraint: string
        if (!is_null($groupPrivilegeName) && !is_string($groupPrivilegeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupPrivilegeName, true), gettype($groupPrivilegeName)), __LINE__);
        }
        if (is_null($groupPrivilegeName) || (is_array($groupPrivilegeName) && empty($groupPrivilegeName))) {
            unset($this->GroupPrivilegeName);
        } else {
            $this->GroupPrivilegeName = $groupPrivilegeName;
        }
        return $this;
    }
    /**
     * Get GroupPrivilegeLevel value
     * @return string|null
     */
    public function getGroupPrivilegeLevel()
    {
        return $this->GroupPrivilegeLevel;
    }
    /**
     * Set GroupPrivilegeLevel value
     * @uses \EnumType\Enumerations_PrivlegeLevel::valueIsValid()
     * @uses \EnumType\Enumerations_PrivlegeLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupPrivilegeLevel
     * @return \StructType\AuthenticateUser_GroupRight
     */
    public function setGroupPrivilegeLevel($groupPrivilegeLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_PrivlegeLevel::valueIsValid($groupPrivilegeLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_PrivlegeLevel', is_array($groupPrivilegeLevel) ? implode(', ', $groupPrivilegeLevel) : var_export($groupPrivilegeLevel, true), implode(', ', \EnumType\Enumerations_PrivlegeLevel::getValidValues())), __LINE__);
        }
        $this->GroupPrivilegeLevel = $groupPrivilegeLevel;
        return $this;
    }
}
