<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateUser.Commission StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthenticateUser.Commission
 * @subpackage Structs
 */
class AuthenticateUser_Commission extends AbstractStructBase
{
    /**
     * The FlatRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FlatRate;
    /**
     * The Percentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Percentage;
    /**
     * The MinimumCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MinimumCommission;
    /**
     * The MaximumCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MaximumCommission;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for AuthenticateUser.Commission
     * @uses AuthenticateUser_Commission::setFlatRate()
     * @uses AuthenticateUser_Commission::setPercentage()
     * @uses AuthenticateUser_Commission::setMinimumCommission()
     * @uses AuthenticateUser_Commission::setMaximumCommission()
     * @uses AuthenticateUser_Commission::setPaymentMethod()
     * @uses AuthenticateUser_Commission::setPaymentMethodType()
     * @uses AuthenticateUser_Commission::setCurrency()
     * @param float $flatRate
     * @param float $percentage
     * @param float $minimumCommission
     * @param float $maximumCommission
     * @param string $paymentMethod
     * @param string $paymentMethodType
     * @param string $currency
     */
    public function __construct($flatRate = null, $percentage = null, $minimumCommission = null, $maximumCommission = null, $paymentMethod = null, $paymentMethodType = null, $currency = null)
    {
        $this
            ->setFlatRate($flatRate)
            ->setPercentage($percentage)
            ->setMinimumCommission($minimumCommission)
            ->setMaximumCommission($maximumCommission)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentMethodType($paymentMethodType)
            ->setCurrency($currency);
    }
    /**
     * Get FlatRate value
     * @return float|null
     */
    public function getFlatRate()
    {
        return $this->FlatRate;
    }
    /**
     * Set FlatRate value
     * @param float $flatRate
     * @return \StructType\AuthenticateUser_Commission
     */
    public function setFlatRate($flatRate = null)
    {
        // validation for constraint: float
        if (!is_null($flatRate) && !(is_float($flatRate) || is_numeric($flatRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($flatRate, true), gettype($flatRate)), __LINE__);
        }
        $this->FlatRate = $flatRate;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\AuthenticateUser_Commission
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get MinimumCommission value
     * @return float|null
     */
    public function getMinimumCommission()
    {
        return $this->MinimumCommission;
    }
    /**
     * Set MinimumCommission value
     * @param float $minimumCommission
     * @return \StructType\AuthenticateUser_Commission
     */
    public function setMinimumCommission($minimumCommission = null)
    {
        // validation for constraint: float
        if (!is_null($minimumCommission) && !(is_float($minimumCommission) || is_numeric($minimumCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumCommission, true), gettype($minimumCommission)), __LINE__);
        }
        $this->MinimumCommission = $minimumCommission;
        return $this;
    }
    /**
     * Get MaximumCommission value
     * @return float|null
     */
    public function getMaximumCommission()
    {
        return $this->MaximumCommission;
    }
    /**
     * Set MaximumCommission value
     * @param float $maximumCommission
     * @return \StructType\AuthenticateUser_Commission
     */
    public function setMaximumCommission($maximumCommission = null)
    {
        // validation for constraint: float
        if (!is_null($maximumCommission) && !(is_float($maximumCommission) || is_numeric($maximumCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumCommission, true), gettype($maximumCommission)), __LINE__);
        }
        $this->MaximumCommission = $maximumCommission;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @uses \EnumType\Enumerations_PaymentMethodTypes::valueIsValid()
     * @uses \EnumType\Enumerations_PaymentMethodTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethod
     * @return \StructType\AuthenticateUser_Commission
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_PaymentMethodTypes::valueIsValid($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_PaymentMethodTypes', is_array($paymentMethod) ? implode(', ', $paymentMethod) : var_export($paymentMethod, true), implode(', ', \EnumType\Enumerations_PaymentMethodTypes::getValidValues())), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodType
     * @return \StructType\AuthenticateUser_Commission
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodType) && !is_string($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodType, true), gettype($paymentMethodType)), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\AuthenticateUser_Commission
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
