<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateUser StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthenticateUser
 * @subpackage Structs
 */
class AuthenticateUser extends TransactionInfo
{
    /**
     * The AuthenticateUserRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticateUser
     */
    public $AuthenticateUserRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The FunctionTypeName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FunctionTypeName;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultMessage;
    /**
     * The PasswordStrength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PasswordStrength;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserID;
    /**
     * The DaysUntilPasswordChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DaysUntilPasswordChange;
    /**
     * The SystemUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticateUser_UserInfo
     */
    public $SystemUser;
    /**
     * The AgencyUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticateUser_AgencyInfo
     */
    public $AgencyUser;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for AuthenticateUser
     * @uses AuthenticateUser::setAuthenticateUserRequest()
     * @uses AuthenticateUser::setActionType()
     * @uses AuthenticateUser::setUserName()
     * @uses AuthenticateUser::setPassword()
     * @uses AuthenticateUser::setFunctionTypeName()
     * @uses AuthenticateUser::setResultCode()
     * @uses AuthenticateUser::setResultMessage()
     * @uses AuthenticateUser::setPasswordStrength()
     * @uses AuthenticateUser::setUserID()
     * @uses AuthenticateUser::setDaysUntilPasswordChange()
     * @uses AuthenticateUser::setSystemUser()
     * @uses AuthenticateUser::setAgencyUser()
     * @uses AuthenticateUser::setExceptions()
     * @param \StructType\AuthenticateUser $authenticateUserRequest
     * @param string $actionType
     * @param string $userName
     * @param string $password
     * @param string $functionTypeName
     * @param string $resultCode
     * @param string $resultMessage
     * @param int $passwordStrength
     * @param string $userID
     * @param string $daysUntilPasswordChange
     * @param \StructType\AuthenticateUser_UserInfo $systemUser
     * @param \StructType\AuthenticateUser_AgencyInfo $agencyUser
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\AuthenticateUser $authenticateUserRequest = null, $actionType = null, $userName = null, $password = null, $functionTypeName = null, $resultCode = null, $resultMessage = null, $passwordStrength = null, $userID = null, $daysUntilPasswordChange = null, \StructType\AuthenticateUser_UserInfo $systemUser = null, \StructType\AuthenticateUser_AgencyInfo $agencyUser = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setAuthenticateUserRequest($authenticateUserRequest)
            ->setActionType($actionType)
            ->setUserName($userName)
            ->setPassword($password)
            ->setFunctionTypeName($functionTypeName)
            ->setResultCode($resultCode)
            ->setResultMessage($resultMessage)
            ->setPasswordStrength($passwordStrength)
            ->setUserID($userID)
            ->setDaysUntilPasswordChange($daysUntilPasswordChange)
            ->setSystemUser($systemUser)
            ->setAgencyUser($agencyUser)
            ->setExceptions($exceptions);
    }
    /**
     * Get AuthenticateUserRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticateUser|null
     */
    public function getAuthenticateUserRequest()
    {
        return isset($this->AuthenticateUserRequest) ? $this->AuthenticateUserRequest : null;
    }
    /**
     * Set AuthenticateUserRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticateUser $authenticateUserRequest
     * @return \StructType\AuthenticateUser
     */
    public function setAuthenticateUserRequest(\StructType\AuthenticateUser $authenticateUserRequest = null)
    {
        if (is_null($authenticateUserRequest) || (is_array($authenticateUserRequest) && empty($authenticateUserRequest))) {
            unset($this->AuthenticateUserRequest);
        } else {
            $this->AuthenticateUserRequest = $authenticateUserRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\AuthenticateUser_ActionTypes::valueIsValid()
     * @uses \EnumType\AuthenticateUser_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\AuthenticateUser
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AuthenticateUser_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AuthenticateUser_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\AuthenticateUser_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\AuthenticateUser
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AuthenticateUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get FunctionTypeName value
     * @return string|null
     */
    public function getFunctionTypeName()
    {
        return $this->FunctionTypeName;
    }
    /**
     * Set FunctionTypeName value
     * @param string $functionTypeName
     * @return \StructType\AuthenticateUser
     */
    public function setFunctionTypeName($functionTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($functionTypeName) && !is_string($functionTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($functionTypeName, true), gettype($functionTypeName)), __LINE__);
        }
        $this->FunctionTypeName = $functionTypeName;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @uses \EnumType\Enumerations_AuthenticationResponseCodes::valueIsValid()
     * @uses \EnumType\Enumerations_AuthenticationResponseCodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultCode
     * @return \StructType\AuthenticateUser
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_AuthenticationResponseCodes::valueIsValid($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_AuthenticationResponseCodes', is_array($resultCode) ? implode(', ', $resultCode) : var_export($resultCode, true), implode(', ', \EnumType\Enumerations_AuthenticationResponseCodes::getValidValues())), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultMessage()
    {
        return isset($this->ResultMessage) ? $this->ResultMessage : null;
    }
    /**
     * Set ResultMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultMessage
     * @return \StructType\AuthenticateUser
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        if (is_null($resultMessage) || (is_array($resultMessage) && empty($resultMessage))) {
            unset($this->ResultMessage);
        } else {
            $this->ResultMessage = $resultMessage;
        }
        return $this;
    }
    /**
     * Get PasswordStrength value
     * @return int|null
     */
    public function getPasswordStrength()
    {
        return $this->PasswordStrength;
    }
    /**
     * Set PasswordStrength value
     * @param int $passwordStrength
     * @return \StructType\AuthenticateUser
     */
    public function setPasswordStrength($passwordStrength = null)
    {
        // validation for constraint: int
        if (!is_null($passwordStrength) && !(is_int($passwordStrength) || ctype_digit($passwordStrength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passwordStrength, true), gettype($passwordStrength)), __LINE__);
        }
        $this->PasswordStrength = $passwordStrength;
        return $this;
    }
    /**
     * Get UserID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserID()
    {
        return isset($this->UserID) ? $this->UserID : null;
    }
    /**
     * Set UserID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userID
     * @return \StructType\AuthenticateUser
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        if (is_null($userID) || (is_array($userID) && empty($userID))) {
            unset($this->UserID);
        } else {
            $this->UserID = $userID;
        }
        return $this;
    }
    /**
     * Get DaysUntilPasswordChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDaysUntilPasswordChange()
    {
        return isset($this->DaysUntilPasswordChange) ? $this->DaysUntilPasswordChange : null;
    }
    /**
     * Set DaysUntilPasswordChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $daysUntilPasswordChange
     * @return \StructType\AuthenticateUser
     */
    public function setDaysUntilPasswordChange($daysUntilPasswordChange = null)
    {
        // validation for constraint: string
        if (!is_null($daysUntilPasswordChange) && !is_string($daysUntilPasswordChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daysUntilPasswordChange, true), gettype($daysUntilPasswordChange)), __LINE__);
        }
        if (is_null($daysUntilPasswordChange) || (is_array($daysUntilPasswordChange) && empty($daysUntilPasswordChange))) {
            unset($this->DaysUntilPasswordChange);
        } else {
            $this->DaysUntilPasswordChange = $daysUntilPasswordChange;
        }
        return $this;
    }
    /**
     * Get SystemUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticateUser_UserInfo|null
     */
    public function getSystemUser()
    {
        return isset($this->SystemUser) ? $this->SystemUser : null;
    }
    /**
     * Set SystemUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticateUser_UserInfo $systemUser
     * @return \StructType\AuthenticateUser
     */
    public function setSystemUser(\StructType\AuthenticateUser_UserInfo $systemUser = null)
    {
        if (is_null($systemUser) || (is_array($systemUser) && empty($systemUser))) {
            unset($this->SystemUser);
        } else {
            $this->SystemUser = $systemUser;
        }
        return $this;
    }
    /**
     * Get AgencyUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticateUser_AgencyInfo|null
     */
    public function getAgencyUser()
    {
        return isset($this->AgencyUser) ? $this->AgencyUser : null;
    }
    /**
     * Set AgencyUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticateUser_AgencyInfo $agencyUser
     * @return \StructType\AuthenticateUser
     */
    public function setAgencyUser(\StructType\AuthenticateUser_AgencyInfo $agencyUser = null)
    {
        if (is_null($agencyUser) || (is_array($agencyUser) && empty($agencyUser))) {
            unset($this->AgencyUser);
        } else {
            $this->AgencyUser = $agencyUser;
        }
        return $this;
    }
    /**
     * Get Exceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return isset($this->Exceptions) ? $this->Exceptions : null;
    }
    /**
     * Set Exceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\AuthenticateUser
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        if (is_null($exceptions) || (is_array($exceptions) && empty($exceptions))) {
            unset($this->Exceptions);
        } else {
            $this->Exceptions = $exceptions;
        }
        return $this;
    }
}
