<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAContactInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TAContactInfo
 * @subpackage Structs
 */
class TAContactInfo extends AbstractStructBase
{
    /**
     * The OriginalContactFieldValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalContactFieldValue;
    /**
     * The ContactField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ContactField;
    /**
     * The ContactType
     * @var string
     */
    public $ContactType;
    /**
     * The PreferredContactMethod
     * @var bool
     */
    public $PreferredContactMethod;
    /**
     * Constructor method for TAContactInfo
     * @uses TAContactInfo::setOriginalContactFieldValue()
     * @uses TAContactInfo::setContactField()
     * @uses TAContactInfo::setContactType()
     * @uses TAContactInfo::setPreferredContactMethod()
     * @param string $originalContactFieldValue
     * @param string $contactField
     * @param string $contactType
     * @param bool $preferredContactMethod
     */
    public function __construct($originalContactFieldValue = null, $contactField = null, $contactType = null, $preferredContactMethod = null)
    {
        $this
            ->setOriginalContactFieldValue($originalContactFieldValue)
            ->setContactField($contactField)
            ->setContactType($contactType)
            ->setPreferredContactMethod($preferredContactMethod);
    }
    /**
     * Get OriginalContactFieldValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalContactFieldValue()
    {
        return isset($this->OriginalContactFieldValue) ? $this->OriginalContactFieldValue : null;
    }
    /**
     * Set OriginalContactFieldValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalContactFieldValue
     * @return \StructType\TAContactInfo
     */
    public function setOriginalContactFieldValue($originalContactFieldValue = null)
    {
        // validation for constraint: string
        if (!is_null($originalContactFieldValue) && !is_string($originalContactFieldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalContactFieldValue, true), gettype($originalContactFieldValue)), __LINE__);
        }
        if (is_null($originalContactFieldValue) || (is_array($originalContactFieldValue) && empty($originalContactFieldValue))) {
            unset($this->OriginalContactFieldValue);
        } else {
            $this->OriginalContactFieldValue = $originalContactFieldValue;
        }
        return $this;
    }
    /**
     * Get ContactField value
     * @return string|null
     */
    public function getContactField()
    {
        return $this->ContactField;
    }
    /**
     * Set ContactField value
     * @param string $contactField
     * @return \StructType\TAContactInfo
     */
    public function setContactField($contactField = null)
    {
        // validation for constraint: string
        if (!is_null($contactField) && !is_string($contactField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactField, true), gettype($contactField)), __LINE__);
        }
        $this->ContactField = $contactField;
        return $this;
    }
    /**
     * Get ContactType value
     * @return string|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @uses \EnumType\Enumerations_ContactTypes::valueIsValid()
     * @uses \EnumType\Enumerations_ContactTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contactType
     * @return \StructType\TAContactInfo
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_ContactTypes::valueIsValid($contactType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_ContactTypes', is_array($contactType) ? implode(', ', $contactType) : var_export($contactType, true), implode(', ', \EnumType\Enumerations_ContactTypes::getValidValues())), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get PreferredContactMethod value
     * @return bool|null
     */
    public function getPreferredContactMethod()
    {
        return $this->PreferredContactMethod;
    }
    /**
     * Set PreferredContactMethod value
     * @param bool $preferredContactMethod
     * @return \StructType\TAContactInfo
     */
    public function setPreferredContactMethod($preferredContactMethod = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferredContactMethod) && !is_bool($preferredContactMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferredContactMethod, true), gettype($preferredContactMethod)), __LINE__);
        }
        $this->PreferredContactMethod = $preferredContactMethod;
        return $this;
    }
}
