<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgencyFundsTransfer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AgencyFundsTransfer
 * @subpackage Structs
 */
class AgencyFundsTransfer extends TransactionInfo
{
    /**
     * The AgencyFundsTransferRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AgencyFundsTransfer
     */
    public $AgencyFundsTransferRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The ChildIATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ChildIATANumber;
    /**
     * The ParentIATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ParentIATANumber;
    /**
     * Constructor method for AgencyFundsTransfer
     * @uses AgencyFundsTransfer::setAgencyFundsTransferRequest()
     * @uses AgencyFundsTransfer::setActionType()
     * @uses AgencyFundsTransfer::setAmount()
     * @uses AgencyFundsTransfer::setChildIATANumber()
     * @uses AgencyFundsTransfer::setParentIATANumber()
     * @param \StructType\AgencyFundsTransfer $agencyFundsTransferRequest
     * @param string $actionType
     * @param float $amount
     * @param string $childIATANumber
     * @param string $parentIATANumber
     */
    public function __construct(\StructType\AgencyFundsTransfer $agencyFundsTransferRequest = null, $actionType = null, $amount = null, $childIATANumber = null, $parentIATANumber = null)
    {
        $this
            ->setAgencyFundsTransferRequest($agencyFundsTransferRequest)
            ->setActionType($actionType)
            ->setAmount($amount)
            ->setChildIATANumber($childIATANumber)
            ->setParentIATANumber($parentIATANumber);
    }
    /**
     * Get AgencyFundsTransferRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AgencyFundsTransfer|null
     */
    public function getAgencyFundsTransferRequest()
    {
        return isset($this->AgencyFundsTransferRequest) ? $this->AgencyFundsTransferRequest : null;
    }
    /**
     * Set AgencyFundsTransferRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AgencyFundsTransfer $agencyFundsTransferRequest
     * @return \StructType\AgencyFundsTransfer
     */
    public function setAgencyFundsTransferRequest(\StructType\AgencyFundsTransfer $agencyFundsTransferRequest = null)
    {
        if (is_null($agencyFundsTransferRequest) || (is_array($agencyFundsTransferRequest) && empty($agencyFundsTransferRequest))) {
            unset($this->AgencyFundsTransferRequest);
        } else {
            $this->AgencyFundsTransferRequest = $agencyFundsTransferRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\AgencyFundsTransfer_ActionTypes::valueIsValid()
     * @uses \EnumType\AgencyFundsTransfer_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\AgencyFundsTransfer
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AgencyFundsTransfer_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AgencyFundsTransfer_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\AgencyFundsTransfer_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AgencyFundsTransfer
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ChildIATANumber value
     * @return string|null
     */
    public function getChildIATANumber()
    {
        return $this->ChildIATANumber;
    }
    /**
     * Set ChildIATANumber value
     * @param string $childIATANumber
     * @return \StructType\AgencyFundsTransfer
     */
    public function setChildIATANumber($childIATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($childIATANumber) && !is_string($childIATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childIATANumber, true), gettype($childIATANumber)), __LINE__);
        }
        $this->ChildIATANumber = $childIATANumber;
        return $this;
    }
    /**
     * Get ParentIATANumber value
     * @return string|null
     */
    public function getParentIATANumber()
    {
        return $this->ParentIATANumber;
    }
    /**
     * Set ParentIATANumber value
     * @param string $parentIATANumber
     * @return \StructType\AgencyFundsTransfer
     */
    public function setParentIATANumber($parentIATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($parentIATANumber) && !is_string($parentIATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentIATANumber, true), gettype($parentIATANumber)), __LINE__);
        }
        $this->ParentIATANumber = $parentIATANumber;
        return $this;
    }
}
