<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfViewAgencyListItem ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfViewAgencyListItem
 * @subpackage Arrays
 */
class ArrayOfViewAgencyListItem extends AbstractStructArrayBase
{
    /**
     * The ViewAgencyListItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ViewAgencyListItem[]
     */
    public $ViewAgencyListItem;
    /**
     * Constructor method for ArrayOfViewAgencyListItem
     * @uses ArrayOfViewAgencyListItem::setViewAgencyListItem()
     * @param \StructType\ViewAgencyListItem[] $viewAgencyListItem
     */
    public function __construct(array $viewAgencyListItem = array())
    {
        $this
            ->setViewAgencyListItem($viewAgencyListItem);
    }
    /**
     * Get ViewAgencyListItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ViewAgencyListItem[]|null
     */
    public function getViewAgencyListItem()
    {
        return isset($this->ViewAgencyListItem) ? $this->ViewAgencyListItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setViewAgencyListItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setViewAgencyListItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateViewAgencyListItemForArrayConstraintsFromSetViewAgencyListItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfViewAgencyListItemViewAgencyListItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfViewAgencyListItemViewAgencyListItemItem instanceof \StructType\ViewAgencyListItem) {
                $invalidValues[] = is_object($arrayOfViewAgencyListItemViewAgencyListItemItem) ? get_class($arrayOfViewAgencyListItemViewAgencyListItemItem) : sprintf('%s(%s)', gettype($arrayOfViewAgencyListItemViewAgencyListItemItem), var_export($arrayOfViewAgencyListItemViewAgencyListItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ViewAgencyListItem property can only contain items of type \StructType\ViewAgencyListItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ViewAgencyListItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ViewAgencyListItem[] $viewAgencyListItem
     * @return \ArrayType\ArrayOfViewAgencyListItem
     */
    public function setViewAgencyListItem(array $viewAgencyListItem = array())
    {
        // validation for constraint: array
        if ('' !== ($viewAgencyListItemArrayErrorMessage = self::validateViewAgencyListItemForArrayConstraintsFromSetViewAgencyListItem($viewAgencyListItem))) {
            throw new \InvalidArgumentException($viewAgencyListItemArrayErrorMessage, __LINE__);
        }
        if (is_null($viewAgencyListItem) || (is_array($viewAgencyListItem) && empty($viewAgencyListItem))) {
            unset($this->ViewAgencyListItem);
        } else {
            $this->ViewAgencyListItem = $viewAgencyListItem;
        }
        return $this;
    }
    /**
     * Add item to ViewAgencyListItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ViewAgencyListItem $item
     * @return \ArrayType\ArrayOfViewAgencyListItem
     */
    public function addToViewAgencyListItem(\StructType\ViewAgencyListItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ViewAgencyListItem) {
            throw new \InvalidArgumentException(sprintf('The ViewAgencyListItem property can only contain items of type \StructType\ViewAgencyListItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ViewAgencyListItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ViewAgencyListItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ViewAgencyListItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ViewAgencyListItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ViewAgencyListItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ViewAgencyListItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ViewAgencyListItem
     */
    public function getAttributeName()
    {
        return 'ViewAgencyListItem';
    }
}
