<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewFinanceAgents StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewFinanceAgents
 * @subpackage Structs
 */
class ViewFinanceAgents extends AbstractStructBase
{
    /**
     * The AgentName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgentName;
    /**
     * The IATA
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATA;
    /**
     * Constructor method for ViewFinanceAgents
     * @uses ViewFinanceAgents::setAgentName()
     * @uses ViewFinanceAgents::setIATA()
     * @param string $agentName
     * @param string $iATA
     */
    public function __construct($agentName = null, $iATA = null)
    {
        $this
            ->setAgentName($agentName)
            ->setIATA($iATA);
    }
    /**
     * Get AgentName value
     * @return string|null
     */
    public function getAgentName()
    {
        return $this->AgentName;
    }
    /**
     * Set AgentName value
     * @param string $agentName
     * @return \StructType\ViewFinanceAgents
     */
    public function setAgentName($agentName = null)
    {
        // validation for constraint: string
        if (!is_null($agentName) && !is_string($agentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentName, true), gettype($agentName)), __LINE__);
        }
        $this->AgentName = $agentName;
        return $this;
    }
    /**
     * Get IATA value
     * @return string|null
     */
    public function getIATA()
    {
        return $this->IATA;
    }
    /**
     * Set IATA value
     * @param string $iATA
     * @return \StructType\ViewFinanceAgents
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA, true), gettype($iATA)), __LINE__);
        }
        $this->IATA = $iATA;
        return $this;
    }
}
