<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewCreditLimitHistory StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewCreditLimitHistory
 * @subpackage Structs
 */
class ViewCreditLimitHistory extends AbstractStructBase
{
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyName;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserID;
    /**
     * The CreditLimitAdded
     * @var float
     */
    public $CreditLimitAdded;
    /**
     * The CreditLimit
     * @var float
     */
    public $CreditLimit;
    /**
     * The AgencyCurrency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyCurrency;
    /**
     * The TransactionDate
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TransactionType;
    /**
     * Constructor method for ViewCreditLimitHistory
     * @uses ViewCreditLimitHistory::setIATANumber()
     * @uses ViewCreditLimitHistory::setAgencyName()
     * @uses ViewCreditLimitHistory::setUserID()
     * @uses ViewCreditLimitHistory::setCreditLimitAdded()
     * @uses ViewCreditLimitHistory::setCreditLimit()
     * @uses ViewCreditLimitHistory::setAgencyCurrency()
     * @uses ViewCreditLimitHistory::setTransactionDate()
     * @uses ViewCreditLimitHistory::setTransactionType()
     * @param string $iATANumber
     * @param string $agencyName
     * @param string $userID
     * @param float $creditLimitAdded
     * @param float $creditLimit
     * @param string $agencyCurrency
     * @param string $transactionDate
     * @param string $transactionType
     */
    public function __construct($iATANumber = null, $agencyName = null, $userID = null, $creditLimitAdded = null, $creditLimit = null, $agencyCurrency = null, $transactionDate = null, $transactionType = null)
    {
        $this
            ->setIATANumber($iATANumber)
            ->setAgencyName($agencyName)
            ->setUserID($userID)
            ->setCreditLimitAdded($creditLimitAdded)
            ->setCreditLimit($creditLimit)
            ->setAgencyCurrency($agencyCurrency)
            ->setTransactionDate($transactionDate)
            ->setTransactionType($transactionType);
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\ViewCreditLimitHistory
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get AgencyName value
     * @return string|null
     */
    public function getAgencyName()
    {
        return $this->AgencyName;
    }
    /**
     * Set AgencyName value
     * @param string $agencyName
     * @return \StructType\ViewCreditLimitHistory
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        $this->AgencyName = $agencyName;
        return $this;
    }
    /**
     * Get UserID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\ViewCreditLimitHistory
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get CreditLimitAdded value
     * @return float|null
     */
    public function getCreditLimitAdded()
    {
        return $this->CreditLimitAdded;
    }
    /**
     * Set CreditLimitAdded value
     * @param float $creditLimitAdded
     * @return \StructType\ViewCreditLimitHistory
     */
    public function setCreditLimitAdded($creditLimitAdded = null)
    {
        // validation for constraint: float
        if (!is_null($creditLimitAdded) && !(is_float($creditLimitAdded) || is_numeric($creditLimitAdded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditLimitAdded, true), gettype($creditLimitAdded)), __LINE__);
        }
        $this->CreditLimitAdded = $creditLimitAdded;
        return $this;
    }
    /**
     * Get CreditLimit value
     * @return float|null
     */
    public function getCreditLimit()
    {
        return $this->CreditLimit;
    }
    /**
     * Set CreditLimit value
     * @param float $creditLimit
     * @return \StructType\ViewCreditLimitHistory
     */
    public function setCreditLimit($creditLimit = null)
    {
        // validation for constraint: float
        if (!is_null($creditLimit) && !(is_float($creditLimit) || is_numeric($creditLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditLimit, true), gettype($creditLimit)), __LINE__);
        }
        $this->CreditLimit = $creditLimit;
        return $this;
    }
    /**
     * Get AgencyCurrency value
     * @return string|null
     */
    public function getAgencyCurrency()
    {
        return $this->AgencyCurrency;
    }
    /**
     * Set AgencyCurrency value
     * @param string $agencyCurrency
     * @return \StructType\ViewCreditLimitHistory
     */
    public function setAgencyCurrency($agencyCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($agencyCurrency) && !is_string($agencyCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyCurrency, true), gettype($agencyCurrency)), __LINE__);
        }
        $this->AgencyCurrency = $agencyCurrency;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\ViewCreditLimitHistory
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @param string $transactionType
     * @return \StructType\ViewCreditLimitHistory
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: string
        if (!is_null($transactionType) && !is_string($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionType, true), gettype($transactionType)), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
}
