<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewBookingHistory StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewBookingHistory
 * @subpackage Structs
 */
class ViewBookingHistory extends AbstractStructBase
{
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The PassengerCount
     * @var int
     */
    public $PassengerCount;
    /**
     * The RouteFrom
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RouteFrom;
    /**
     * The RouteTo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RouteTo;
    /**
     * The BookDateGMT
     * @var string
     */
    public $BookDateGMT;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The BookingAgent
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BookingAgent;
    /**
     * The BookingType
     * @var string
     */
    public $BookingType;
    /**
     * Constructor method for ViewBookingHistory
     * @uses ViewBookingHistory::setSeriesNumber()
     * @uses ViewBookingHistory::setConfirmationNumber()
     * @uses ViewBookingHistory::setFirstName()
     * @uses ViewBookingHistory::setLastName()
     * @uses ViewBookingHistory::setTitle()
     * @uses ViewBookingHistory::setPassengerCount()
     * @uses ViewBookingHistory::setRouteFrom()
     * @uses ViewBookingHistory::setRouteTo()
     * @uses ViewBookingHistory::setBookDateGMT()
     * @uses ViewBookingHistory::setDepartureDate()
     * @uses ViewBookingHistory::setBookingAgent()
     * @uses ViewBookingHistory::setBookingType()
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param string $firstName
     * @param string $lastName
     * @param string $title
     * @param int $passengerCount
     * @param string $routeFrom
     * @param string $routeTo
     * @param string $bookDateGMT
     * @param string $departureDate
     * @param string $bookingAgent
     * @param string $bookingType
     */
    public function __construct($seriesNumber = null, $confirmationNumber = null, $firstName = null, $lastName = null, $title = null, $passengerCount = null, $routeFrom = null, $routeTo = null, $bookDateGMT = null, $departureDate = null, $bookingAgent = null, $bookingType = null)
    {
        $this
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setTitle($title)
            ->setPassengerCount($passengerCount)
            ->setRouteFrom($routeFrom)
            ->setRouteTo($routeTo)
            ->setBookDateGMT($bookDateGMT)
            ->setDepartureDate($departureDate)
            ->setBookingAgent($bookingAgent)
            ->setBookingType($bookingType);
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\ViewBookingHistory
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\ViewBookingHistory
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\ViewBookingHistory
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\ViewBookingHistory
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\ViewBookingHistory
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get PassengerCount value
     * @return int|null
     */
    public function getPassengerCount()
    {
        return $this->PassengerCount;
    }
    /**
     * Set PassengerCount value
     * @param int $passengerCount
     * @return \StructType\ViewBookingHistory
     */
    public function setPassengerCount($passengerCount = null)
    {
        // validation for constraint: int
        if (!is_null($passengerCount) && !(is_int($passengerCount) || ctype_digit($passengerCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerCount, true), gettype($passengerCount)), __LINE__);
        }
        $this->PassengerCount = $passengerCount;
        return $this;
    }
    /**
     * Get RouteFrom value
     * @return string|null
     */
    public function getRouteFrom()
    {
        return $this->RouteFrom;
    }
    /**
     * Set RouteFrom value
     * @param string $routeFrom
     * @return \StructType\ViewBookingHistory
     */
    public function setRouteFrom($routeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($routeFrom) && !is_string($routeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeFrom, true), gettype($routeFrom)), __LINE__);
        }
        $this->RouteFrom = $routeFrom;
        return $this;
    }
    /**
     * Get RouteTo value
     * @return string|null
     */
    public function getRouteTo()
    {
        return $this->RouteTo;
    }
    /**
     * Set RouteTo value
     * @param string $routeTo
     * @return \StructType\ViewBookingHistory
     */
    public function setRouteTo($routeTo = null)
    {
        // validation for constraint: string
        if (!is_null($routeTo) && !is_string($routeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeTo, true), gettype($routeTo)), __LINE__);
        }
        $this->RouteTo = $routeTo;
        return $this;
    }
    /**
     * Get BookDateGMT value
     * @return string|null
     */
    public function getBookDateGMT()
    {
        return $this->BookDateGMT;
    }
    /**
     * Set BookDateGMT value
     * @param string $bookDateGMT
     * @return \StructType\ViewBookingHistory
     */
    public function setBookDateGMT($bookDateGMT = null)
    {
        // validation for constraint: string
        if (!is_null($bookDateGMT) && !is_string($bookDateGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookDateGMT, true), gettype($bookDateGMT)), __LINE__);
        }
        $this->BookDateGMT = $bookDateGMT;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\ViewBookingHistory
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get BookingAgent value
     * @return string|null
     */
    public function getBookingAgent()
    {
        return $this->BookingAgent;
    }
    /**
     * Set BookingAgent value
     * @param string $bookingAgent
     * @return \StructType\ViewBookingHistory
     */
    public function setBookingAgent($bookingAgent = null)
    {
        // validation for constraint: string
        if (!is_null($bookingAgent) && !is_string($bookingAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingAgent, true), gettype($bookingAgent)), __LINE__);
        }
        $this->BookingAgent = $bookingAgent;
        return $this;
    }
    /**
     * Get BookingType value
     * @return string|null
     */
    public function getBookingType()
    {
        return $this->BookingType;
    }
    /**
     * Set BookingType value
     * @uses \EnumType\Enumerations_PNRStatus::valueIsValid()
     * @uses \EnumType\Enumerations_PNRStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingType
     * @return \StructType\ViewBookingHistory
     */
    public function setBookingType($bookingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_PNRStatus::valueIsValid($bookingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_PNRStatus', is_array($bookingType) ? implode(', ', $bookingType) : var_export($bookingType, true), implode(', ', \EnumType\Enumerations_PNRStatus::getValidValues())), __LINE__);
        }
        $this->BookingType = $bookingType;
        return $this;
    }
}
