<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewAgentDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewAgentDetails
 * @subpackage Structs
 */
class ViewAgentDetails extends AbstractStructBase
{
    /**
     * The Status
     * @var int
     */
    public $Status;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserId;
    /**
     * The Firstname
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Firstname;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The Address1
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Mobile;
    /**
     * The EmailId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmailId;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ViewAgentDetails
     * @uses ViewAgentDetails::setStatus()
     * @uses ViewAgentDetails::setUserId()
     * @uses ViewAgentDetails::setFirstname()
     * @uses ViewAgentDetails::setLastName()
     * @uses ViewAgentDetails::setAddress1()
     * @uses ViewAgentDetails::setAddress2()
     * @uses ViewAgentDetails::setCity()
     * @uses ViewAgentDetails::setState()
     * @uses ViewAgentDetails::setCountry()
     * @uses ViewAgentDetails::setZipCode()
     * @uses ViewAgentDetails::setPhone()
     * @uses ViewAgentDetails::setMobile()
     * @uses ViewAgentDetails::setEmailId()
     * @uses ViewAgentDetails::setExceptions()
     * @param int $status
     * @param string $userId
     * @param string $firstname
     * @param string $lastName
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $state
     * @param string $country
     * @param string $zipCode
     * @param string $phone
     * @param string $mobile
     * @param string $emailId
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct($status = null, $userId = null, $firstname = null, $lastName = null, $address1 = null, $address2 = null, $city = null, $state = null, $country = null, $zipCode = null, $phone = null, $mobile = null, $emailId = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setStatus($status)
            ->setUserId($userId)
            ->setFirstname($firstname)
            ->setLastName($lastName)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setState($state)
            ->setCountry($country)
            ->setZipCode($zipCode)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setEmailId($emailId)
            ->setExceptions($exceptions);
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\ViewAgentDetails
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \StructType\ViewAgentDetails
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get Firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->Firstname;
    }
    /**
     * Set Firstname value
     * @param string $firstname
     * @return \StructType\ViewAgentDetails
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->Firstname = $firstname;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\ViewAgentDetails
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\ViewAgentDetails
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\ViewAgentDetails
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\ViewAgentDetails
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\ViewAgentDetails
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\ViewAgentDetails
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \StructType\ViewAgentDetails
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\ViewAgentDetails
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\ViewAgentDetails
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get EmailId value
     * @return string|null
     */
    public function getEmailId()
    {
        return $this->EmailId;
    }
    /**
     * Set EmailId value
     * @param string $emailId
     * @return \StructType\ViewAgentDetails
     */
    public function setEmailId($emailId = null)
    {
        // validation for constraint: string
        if (!is_null($emailId) && !is_string($emailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailId, true), gettype($emailId)), __LINE__);
        }
        $this->EmailId = $emailId;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewAgentDetails
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
