<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopUpDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TopUpDetails
 * @subpackage Structs
 */
class TopUpDetails extends AbstractStructBase
{
    /**
     * The Credit_Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Credit_Amt;
    /**
     * The Credit_Currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Credit_Currency;
    /**
     * The Deposit_Nfn_Num
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Deposit_Nfn_Num;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IATA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATA;
    /**
     * Constructor method for TopUpDetails
     * @uses TopUpDetails::setCredit_Amt()
     * @uses TopUpDetails::setCredit_Currency()
     * @uses TopUpDetails::setDeposit_Nfn_Num()
     * @uses TopUpDetails::setDescription()
     * @uses TopUpDetails::setIATA()
     * @param float $credit_Amt
     * @param string $credit_Currency
     * @param string $deposit_Nfn_Num
     * @param string $description
     * @param string $iATA
     */
    public function __construct($credit_Amt = null, $credit_Currency = null, $deposit_Nfn_Num = null, $description = null, $iATA = null)
    {
        $this
            ->setCredit_Amt($credit_Amt)
            ->setCredit_Currency($credit_Currency)
            ->setDeposit_Nfn_Num($deposit_Nfn_Num)
            ->setDescription($description)
            ->setIATA($iATA);
    }
    /**
     * Get Credit_Amt value
     * @return float|null
     */
    public function getCredit_Amt()
    {
        return $this->Credit_Amt;
    }
    /**
     * Set Credit_Amt value
     * @param float $credit_Amt
     * @return \StructType\TopUpDetails
     */
    public function setCredit_Amt($credit_Amt = null)
    {
        // validation for constraint: float
        if (!is_null($credit_Amt) && !(is_float($credit_Amt) || is_numeric($credit_Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($credit_Amt, true), gettype($credit_Amt)), __LINE__);
        }
        $this->Credit_Amt = $credit_Amt;
        return $this;
    }
    /**
     * Get Credit_Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCredit_Currency()
    {
        return isset($this->Credit_Currency) ? $this->Credit_Currency : null;
    }
    /**
     * Set Credit_Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $credit_Currency
     * @return \StructType\TopUpDetails
     */
    public function setCredit_Currency($credit_Currency = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Currency) && !is_string($credit_Currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_Currency, true), gettype($credit_Currency)), __LINE__);
        }
        if (is_null($credit_Currency) || (is_array($credit_Currency) && empty($credit_Currency))) {
            unset($this->Credit_Currency);
        } else {
            $this->Credit_Currency = $credit_Currency;
        }
        return $this;
    }
    /**
     * Get Deposit_Nfn_Num value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeposit_Nfn_Num()
    {
        return isset($this->Deposit_Nfn_Num) ? $this->Deposit_Nfn_Num : null;
    }
    /**
     * Set Deposit_Nfn_Num value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deposit_Nfn_Num
     * @return \StructType\TopUpDetails
     */
    public function setDeposit_Nfn_Num($deposit_Nfn_Num = null)
    {
        // validation for constraint: string
        if (!is_null($deposit_Nfn_Num) && !is_string($deposit_Nfn_Num)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deposit_Nfn_Num, true), gettype($deposit_Nfn_Num)), __LINE__);
        }
        if (is_null($deposit_Nfn_Num) || (is_array($deposit_Nfn_Num) && empty($deposit_Nfn_Num))) {
            unset($this->Deposit_Nfn_Num);
        } else {
            $this->Deposit_Nfn_Num = $deposit_Nfn_Num;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\TopUpDetails
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IATA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATA()
    {
        return isset($this->IATA) ? $this->IATA : null;
    }
    /**
     * Set IATA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATA
     * @return \StructType\TopUpDetails
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA, true), gettype($iATA)), __LINE__);
        }
        if (is_null($iATA) || (is_array($iATA) && empty($iATA))) {
            unset($this->IATA);
        } else {
            $this->IATA = $iATA;
        }
        return $this;
    }
}
