<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAgentList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAgentList
 * @subpackage Structs
 */
class RetrieveAgentList extends TransactionInfo
{
    /**
     * The retrieveAgentListRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAgentList
     */
    public $retrieveAgentListRequest;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The IncludeChildAgents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeChildAgents;
    /**
     * Constructor method for RetrieveAgentList
     * @uses RetrieveAgentList::setRetrieveAgentListRequest()
     * @uses RetrieveAgentList::setIATANumber()
     * @uses RetrieveAgentList::setIncludeChildAgents()
     * @param \StructType\RetrieveAgentList $retrieveAgentListRequest
     * @param string $iATANumber
     * @param bool $includeChildAgents
     */
    public function __construct(\StructType\RetrieveAgentList $retrieveAgentListRequest = null, $iATANumber = null, $includeChildAgents = null)
    {
        $this
            ->setRetrieveAgentListRequest($retrieveAgentListRequest)
            ->setIATANumber($iATANumber)
            ->setIncludeChildAgents($includeChildAgents);
    }
    /**
     * Get retrieveAgentListRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAgentList|null
     */
    public function getRetrieveAgentListRequest()
    {
        return isset($this->retrieveAgentListRequest) ? $this->retrieveAgentListRequest : null;
    }
    /**
     * Set retrieveAgentListRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAgentList $retrieveAgentListRequest
     * @return \StructType\RetrieveAgentList
     */
    public function setRetrieveAgentListRequest(\StructType\RetrieveAgentList $retrieveAgentListRequest = null)
    {
        if (is_null($retrieveAgentListRequest) || (is_array($retrieveAgentListRequest) && empty($retrieveAgentListRequest))) {
            unset($this->retrieveAgentListRequest);
        } else {
            $this->retrieveAgentListRequest = $retrieveAgentListRequest;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATANumber()
    {
        return isset($this->IATANumber) ? $this->IATANumber : null;
    }
    /**
     * Set IATANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATANumber
     * @return \StructType\RetrieveAgentList
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        if (is_null($iATANumber) || (is_array($iATANumber) && empty($iATANumber))) {
            unset($this->IATANumber);
        } else {
            $this->IATANumber = $iATANumber;
        }
        return $this;
    }
    /**
     * Get IncludeChildAgents value
     * @return bool|null
     */
    public function getIncludeChildAgents()
    {
        return $this->IncludeChildAgents;
    }
    /**
     * Set IncludeChildAgents value
     * @param bool $includeChildAgents
     * @return \StructType\RetrieveAgentList
     */
    public function setIncludeChildAgents($includeChildAgents = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildAgents) && !is_bool($includeChildAgents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildAgents, true), gettype($includeChildAgents)), __LINE__);
        }
        $this->IncludeChildAgents = $includeChildAgents;
        return $this;
    }
}
