<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAgencyPNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAgencyPNR
 * @subpackage Structs
 */
class RetrieveAgencyPNR extends TransactionInfo
{
    /**
     * The RetrieveSearchPNRRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAgencyPNR
     */
    public $RetrieveSearchPNRRequest;
    /**
     * The ActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The BookingReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingReferenceNumber;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureDate;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The IncludeChildAgencies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeChildAgencies;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The PaymentReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentReferenceNumber;
    /**
     * Constructor method for RetrieveAgencyPNR
     * @uses RetrieveAgencyPNR::setRetrieveSearchPNRRequest()
     * @uses RetrieveAgencyPNR::setActionType()
     * @uses RetrieveAgencyPNR::setBookingReferenceNumber()
     * @uses RetrieveAgencyPNR::setDepartureDate()
     * @uses RetrieveAgencyPNR::setEmail()
     * @uses RetrieveAgencyPNR::setFirstName()
     * @uses RetrieveAgencyPNR::setIncludeChildAgencies()
     * @uses RetrieveAgencyPNR::setLastName()
     * @uses RetrieveAgencyPNR::setPaymentReferenceNumber()
     * @param \StructType\RetrieveAgencyPNR $retrieveSearchPNRRequest
     * @param string $actionType
     * @param string $bookingReferenceNumber
     * @param string $departureDate
     * @param string $email
     * @param string $firstName
     * @param bool $includeChildAgencies
     * @param string $lastName
     * @param string $paymentReferenceNumber
     */
    public function __construct(\StructType\RetrieveAgencyPNR $retrieveSearchPNRRequest = null, $actionType = null, $bookingReferenceNumber = null, $departureDate = null, $email = null, $firstName = null, $includeChildAgencies = null, $lastName = null, $paymentReferenceNumber = null)
    {
        $this
            ->setRetrieveSearchPNRRequest($retrieveSearchPNRRequest)
            ->setActionType($actionType)
            ->setBookingReferenceNumber($bookingReferenceNumber)
            ->setDepartureDate($departureDate)
            ->setEmail($email)
            ->setFirstName($firstName)
            ->setIncludeChildAgencies($includeChildAgencies)
            ->setLastName($lastName)
            ->setPaymentReferenceNumber($paymentReferenceNumber);
    }
    /**
     * Get RetrieveSearchPNRRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAgencyPNR|null
     */
    public function getRetrieveSearchPNRRequest()
    {
        return isset($this->RetrieveSearchPNRRequest) ? $this->RetrieveSearchPNRRequest : null;
    }
    /**
     * Set RetrieveSearchPNRRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAgencyPNR $retrieveSearchPNRRequest
     * @return \StructType\RetrieveAgencyPNR
     */
    public function setRetrieveSearchPNRRequest(\StructType\RetrieveAgencyPNR $retrieveSearchPNRRequest = null)
    {
        if (is_null($retrieveSearchPNRRequest) || (is_array($retrieveSearchPNRRequest) && empty($retrieveSearchPNRRequest))) {
            unset($this->RetrieveSearchPNRRequest);
        } else {
            $this->RetrieveSearchPNRRequest = $retrieveSearchPNRRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\RetrieveAgencyPNR_ActionTypes::valueIsValid()
     * @uses \EnumType\RetrieveAgencyPNR_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\RetrieveAgencyPNR
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetrieveAgencyPNR_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetrieveAgencyPNR_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\RetrieveAgencyPNR_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get BookingReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingReferenceNumber()
    {
        return isset($this->BookingReferenceNumber) ? $this->BookingReferenceNumber : null;
    }
    /**
     * Set BookingReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingReferenceNumber
     * @return \StructType\RetrieveAgencyPNR
     */
    public function setBookingReferenceNumber($bookingReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReferenceNumber) && !is_string($bookingReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingReferenceNumber, true), gettype($bookingReferenceNumber)), __LINE__);
        }
        if (is_null($bookingReferenceNumber) || (is_array($bookingReferenceNumber) && empty($bookingReferenceNumber))) {
            unset($this->BookingReferenceNumber);
        } else {
            $this->BookingReferenceNumber = $bookingReferenceNumber;
        }
        return $this;
    }
    /**
     * Get DepartureDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureDate()
    {
        return isset($this->DepartureDate) ? $this->DepartureDate : null;
    }
    /**
     * Set DepartureDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureDate
     * @return \StructType\RetrieveAgencyPNR
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        if (is_null($departureDate) || (is_array($departureDate) && empty($departureDate))) {
            unset($this->DepartureDate);
        } else {
            $this->DepartureDate = $departureDate;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\RetrieveAgencyPNR
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\RetrieveAgencyPNR
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get IncludeChildAgencies value
     * @return bool|null
     */
    public function getIncludeChildAgencies()
    {
        return $this->IncludeChildAgencies;
    }
    /**
     * Set IncludeChildAgencies value
     * @param bool $includeChildAgencies
     * @return \StructType\RetrieveAgencyPNR
     */
    public function setIncludeChildAgencies($includeChildAgencies = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildAgencies) && !is_bool($includeChildAgencies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildAgencies, true), gettype($includeChildAgencies)), __LINE__);
        }
        $this->IncludeChildAgencies = $includeChildAgencies;
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\RetrieveAgencyPNR
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get PaymentReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentReferenceNumber()
    {
        return isset($this->PaymentReferenceNumber) ? $this->PaymentReferenceNumber : null;
    }
    /**
     * Set PaymentReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentReferenceNumber
     * @return \StructType\RetrieveAgencyPNR
     */
    public function setPaymentReferenceNumber($paymentReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($paymentReferenceNumber) && !is_string($paymentReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentReferenceNumber, true), gettype($paymentReferenceNumber)), __LINE__);
        }
        if (is_null($paymentReferenceNumber) || (is_array($paymentReferenceNumber) && empty($paymentReferenceNumber))) {
            unset($this->PaymentReferenceNumber);
        } else {
            $this->PaymentReferenceNumber = $paymentReferenceNumber;
        }
        return $this;
    }
}
