<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAgencyInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAgencyInfo
 * @subpackage Structs
 */
class RetrieveAgencyInfo extends TransactionInfo
{
    /**
     * The retrieveAgencyInfoRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAgencyInfo
     */
    public $retrieveAgencyInfoRequest;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * Constructor method for RetrieveAgencyInfo
     * @uses RetrieveAgencyInfo::setRetrieveAgencyInfoRequest()
     * @uses RetrieveAgencyInfo::setIATANumber()
     * @param \StructType\RetrieveAgencyInfo $retrieveAgencyInfoRequest
     * @param string $iATANumber
     */
    public function __construct(\StructType\RetrieveAgencyInfo $retrieveAgencyInfoRequest = null, $iATANumber = null)
    {
        $this
            ->setRetrieveAgencyInfoRequest($retrieveAgencyInfoRequest)
            ->setIATANumber($iATANumber);
    }
    /**
     * Get retrieveAgencyInfoRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAgencyInfo|null
     */
    public function getRetrieveAgencyInfoRequest()
    {
        return isset($this->retrieveAgencyInfoRequest) ? $this->retrieveAgencyInfoRequest : null;
    }
    /**
     * Set retrieveAgencyInfoRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAgencyInfo $retrieveAgencyInfoRequest
     * @return \StructType\RetrieveAgencyInfo
     */
    public function setRetrieveAgencyInfoRequest(\StructType\RetrieveAgencyInfo $retrieveAgencyInfoRequest = null)
    {
        if (is_null($retrieveAgencyInfoRequest) || (is_array($retrieveAgencyInfoRequest) && empty($retrieveAgencyInfoRequest))) {
            unset($this->retrieveAgencyInfoRequest);
        } else {
            $this->retrieveAgencyInfoRequest = $retrieveAgencyInfoRequest;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATANumber()
    {
        return isset($this->IATANumber) ? $this->IATANumber : null;
    }
    /**
     * Set IATANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATANumber
     * @return \StructType\RetrieveAgencyInfo
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        if (is_null($iATANumber) || (is_array($iATANumber) && empty($iATANumber))) {
            unset($this->IATANumber);
        } else {
            $this->IATANumber = $iATANumber;
        }
        return $this;
    }
}
