<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyAgencyCreditLimit StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyAgencyCreditLimit
 * @subpackage Structs
 */
class ModifyAgencyCreditLimit extends TransactionInfo
{
    /**
     * The modifyAgencyCreditLimitRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ModifyAgencyCreditLimit
     */
    public $modifyAgencyCreditLimitRequest;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The LoggedOnIATANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoggedOnIATANumber;
    /**
     * The NewCreditLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NewCreditLimit;
    /**
     * The OriginalCreditLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OriginalCreditLimit;
    /**
     * The OriginalCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalCurrency;
    /**
     * Constructor method for ModifyAgencyCreditLimit
     * @uses ModifyAgencyCreditLimit::setModifyAgencyCreditLimitRequest()
     * @uses ModifyAgencyCreditLimit::setIATANumber()
     * @uses ModifyAgencyCreditLimit::setLoggedOnIATANumber()
     * @uses ModifyAgencyCreditLimit::setNewCreditLimit()
     * @uses ModifyAgencyCreditLimit::setOriginalCreditLimit()
     * @uses ModifyAgencyCreditLimit::setOriginalCurrency()
     * @param \StructType\ModifyAgencyCreditLimit $modifyAgencyCreditLimitRequest
     * @param string $iATANumber
     * @param string $loggedOnIATANumber
     * @param float $newCreditLimit
     * @param float $originalCreditLimit
     * @param string $originalCurrency
     */
    public function __construct(\StructType\ModifyAgencyCreditLimit $modifyAgencyCreditLimitRequest = null, $iATANumber = null, $loggedOnIATANumber = null, $newCreditLimit = null, $originalCreditLimit = null, $originalCurrency = null)
    {
        $this
            ->setModifyAgencyCreditLimitRequest($modifyAgencyCreditLimitRequest)
            ->setIATANumber($iATANumber)
            ->setLoggedOnIATANumber($loggedOnIATANumber)
            ->setNewCreditLimit($newCreditLimit)
            ->setOriginalCreditLimit($originalCreditLimit)
            ->setOriginalCurrency($originalCurrency);
    }
    /**
     * Get modifyAgencyCreditLimitRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ModifyAgencyCreditLimit|null
     */
    public function getModifyAgencyCreditLimitRequest()
    {
        return isset($this->modifyAgencyCreditLimitRequest) ? $this->modifyAgencyCreditLimitRequest : null;
    }
    /**
     * Set modifyAgencyCreditLimitRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ModifyAgencyCreditLimit $modifyAgencyCreditLimitRequest
     * @return \StructType\ModifyAgencyCreditLimit
     */
    public function setModifyAgencyCreditLimitRequest(\StructType\ModifyAgencyCreditLimit $modifyAgencyCreditLimitRequest = null)
    {
        if (is_null($modifyAgencyCreditLimitRequest) || (is_array($modifyAgencyCreditLimitRequest) && empty($modifyAgencyCreditLimitRequest))) {
            unset($this->modifyAgencyCreditLimitRequest);
        } else {
            $this->modifyAgencyCreditLimitRequest = $modifyAgencyCreditLimitRequest;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATANumber()
    {
        return isset($this->IATANumber) ? $this->IATANumber : null;
    }
    /**
     * Set IATANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATANumber
     * @return \StructType\ModifyAgencyCreditLimit
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        if (is_null($iATANumber) || (is_array($iATANumber) && empty($iATANumber))) {
            unset($this->IATANumber);
        } else {
            $this->IATANumber = $iATANumber;
        }
        return $this;
    }
    /**
     * Get LoggedOnIATANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoggedOnIATANumber()
    {
        return isset($this->LoggedOnIATANumber) ? $this->LoggedOnIATANumber : null;
    }
    /**
     * Set LoggedOnIATANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loggedOnIATANumber
     * @return \StructType\ModifyAgencyCreditLimit
     */
    public function setLoggedOnIATANumber($loggedOnIATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($loggedOnIATANumber) && !is_string($loggedOnIATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loggedOnIATANumber, true), gettype($loggedOnIATANumber)), __LINE__);
        }
        if (is_null($loggedOnIATANumber) || (is_array($loggedOnIATANumber) && empty($loggedOnIATANumber))) {
            unset($this->LoggedOnIATANumber);
        } else {
            $this->LoggedOnIATANumber = $loggedOnIATANumber;
        }
        return $this;
    }
    /**
     * Get NewCreditLimit value
     * @return float|null
     */
    public function getNewCreditLimit()
    {
        return $this->NewCreditLimit;
    }
    /**
     * Set NewCreditLimit value
     * @param float $newCreditLimit
     * @return \StructType\ModifyAgencyCreditLimit
     */
    public function setNewCreditLimit($newCreditLimit = null)
    {
        // validation for constraint: float
        if (!is_null($newCreditLimit) && !(is_float($newCreditLimit) || is_numeric($newCreditLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($newCreditLimit, true), gettype($newCreditLimit)), __LINE__);
        }
        $this->NewCreditLimit = $newCreditLimit;
        return $this;
    }
    /**
     * Get OriginalCreditLimit value
     * @return float|null
     */
    public function getOriginalCreditLimit()
    {
        return $this->OriginalCreditLimit;
    }
    /**
     * Set OriginalCreditLimit value
     * @param float $originalCreditLimit
     * @return \StructType\ModifyAgencyCreditLimit
     */
    public function setOriginalCreditLimit($originalCreditLimit = null)
    {
        // validation for constraint: float
        if (!is_null($originalCreditLimit) && !(is_float($originalCreditLimit) || is_numeric($originalCreditLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalCreditLimit, true), gettype($originalCreditLimit)), __LINE__);
        }
        $this->OriginalCreditLimit = $originalCreditLimit;
        return $this;
    }
    /**
     * Get OriginalCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalCurrency()
    {
        return isset($this->OriginalCurrency) ? $this->OriginalCurrency : null;
    }
    /**
     * Set OriginalCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalCurrency
     * @return \StructType\ModifyAgencyCreditLimit
     */
    public function setOriginalCurrency($originalCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originalCurrency) && !is_string($originalCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalCurrency, true), gettype($originalCurrency)), __LINE__);
        }
        if (is_null($originalCurrency) || (is_array($originalCurrency) && empty($originalCurrency))) {
            unset($this->OriginalCurrency);
        } else {
            $this->OriginalCurrency = $originalCurrency;
        }
        return $this;
    }
}
