<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewBalanceInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewBalanceInfo
 * @subpackage Structs
 */
class ViewBalanceInfo extends AbstractStructBase
{
    /**
     * The AgencyBalances
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfBalanceInfo
     */
    public $AgencyBalances;
    /**
     * The TotalChargesForRange
     * @var float
     */
    public $TotalChargesForRange;
    /**
     * The TotalChargesFromInception
     * @var float
     */
    public $TotalChargesFromInception;
    /**
     * The TotalPaymentsForRange
     * @var float
     */
    public $TotalPaymentsForRange;
    /**
     * The TotalPaymentsFromInception
     * @var float
     */
    public $TotalPaymentsFromInception;
    /**
     * The OverallBalanceForRange
     * @var float
     */
    public $OverallBalanceForRange;
    /**
     * The OverallBalanceFromInception
     * @var float
     */
    public $OverallBalanceFromInception;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ViewBalanceInfo
     * @uses ViewBalanceInfo::setAgencyBalances()
     * @uses ViewBalanceInfo::setTotalChargesForRange()
     * @uses ViewBalanceInfo::setTotalChargesFromInception()
     * @uses ViewBalanceInfo::setTotalPaymentsForRange()
     * @uses ViewBalanceInfo::setTotalPaymentsFromInception()
     * @uses ViewBalanceInfo::setOverallBalanceForRange()
     * @uses ViewBalanceInfo::setOverallBalanceFromInception()
     * @uses ViewBalanceInfo::setExceptions()
     * @param \ArrayType\ArrayOfBalanceInfo $agencyBalances
     * @param float $totalChargesForRange
     * @param float $totalChargesFromInception
     * @param float $totalPaymentsForRange
     * @param float $totalPaymentsFromInception
     * @param float $overallBalanceForRange
     * @param float $overallBalanceFromInception
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\ArrayType\ArrayOfBalanceInfo $agencyBalances = null, $totalChargesForRange = null, $totalChargesFromInception = null, $totalPaymentsForRange = null, $totalPaymentsFromInception = null, $overallBalanceForRange = null, $overallBalanceFromInception = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setAgencyBalances($agencyBalances)
            ->setTotalChargesForRange($totalChargesForRange)
            ->setTotalChargesFromInception($totalChargesFromInception)
            ->setTotalPaymentsForRange($totalPaymentsForRange)
            ->setTotalPaymentsFromInception($totalPaymentsFromInception)
            ->setOverallBalanceForRange($overallBalanceForRange)
            ->setOverallBalanceFromInception($overallBalanceFromInception)
            ->setExceptions($exceptions);
    }
    /**
     * Get AgencyBalances value
     * @return \ArrayType\ArrayOfBalanceInfo|null
     */
    public function getAgencyBalances()
    {
        return $this->AgencyBalances;
    }
    /**
     * Set AgencyBalances value
     * @param \ArrayType\ArrayOfBalanceInfo $agencyBalances
     * @return \StructType\ViewBalanceInfo
     */
    public function setAgencyBalances(\ArrayType\ArrayOfBalanceInfo $agencyBalances = null)
    {
        $this->AgencyBalances = $agencyBalances;
        return $this;
    }
    /**
     * Get TotalChargesForRange value
     * @return float|null
     */
    public function getTotalChargesForRange()
    {
        return $this->TotalChargesForRange;
    }
    /**
     * Set TotalChargesForRange value
     * @param float $totalChargesForRange
     * @return \StructType\ViewBalanceInfo
     */
    public function setTotalChargesForRange($totalChargesForRange = null)
    {
        // validation for constraint: float
        if (!is_null($totalChargesForRange) && !(is_float($totalChargesForRange) || is_numeric($totalChargesForRange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalChargesForRange, true), gettype($totalChargesForRange)), __LINE__);
        }
        $this->TotalChargesForRange = $totalChargesForRange;
        return $this;
    }
    /**
     * Get TotalChargesFromInception value
     * @return float|null
     */
    public function getTotalChargesFromInception()
    {
        return $this->TotalChargesFromInception;
    }
    /**
     * Set TotalChargesFromInception value
     * @param float $totalChargesFromInception
     * @return \StructType\ViewBalanceInfo
     */
    public function setTotalChargesFromInception($totalChargesFromInception = null)
    {
        // validation for constraint: float
        if (!is_null($totalChargesFromInception) && !(is_float($totalChargesFromInception) || is_numeric($totalChargesFromInception))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalChargesFromInception, true), gettype($totalChargesFromInception)), __LINE__);
        }
        $this->TotalChargesFromInception = $totalChargesFromInception;
        return $this;
    }
    /**
     * Get TotalPaymentsForRange value
     * @return float|null
     */
    public function getTotalPaymentsForRange()
    {
        return $this->TotalPaymentsForRange;
    }
    /**
     * Set TotalPaymentsForRange value
     * @param float $totalPaymentsForRange
     * @return \StructType\ViewBalanceInfo
     */
    public function setTotalPaymentsForRange($totalPaymentsForRange = null)
    {
        // validation for constraint: float
        if (!is_null($totalPaymentsForRange) && !(is_float($totalPaymentsForRange) || is_numeric($totalPaymentsForRange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPaymentsForRange, true), gettype($totalPaymentsForRange)), __LINE__);
        }
        $this->TotalPaymentsForRange = $totalPaymentsForRange;
        return $this;
    }
    /**
     * Get TotalPaymentsFromInception value
     * @return float|null
     */
    public function getTotalPaymentsFromInception()
    {
        return $this->TotalPaymentsFromInception;
    }
    /**
     * Set TotalPaymentsFromInception value
     * @param float $totalPaymentsFromInception
     * @return \StructType\ViewBalanceInfo
     */
    public function setTotalPaymentsFromInception($totalPaymentsFromInception = null)
    {
        // validation for constraint: float
        if (!is_null($totalPaymentsFromInception) && !(is_float($totalPaymentsFromInception) || is_numeric($totalPaymentsFromInception))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPaymentsFromInception, true), gettype($totalPaymentsFromInception)), __LINE__);
        }
        $this->TotalPaymentsFromInception = $totalPaymentsFromInception;
        return $this;
    }
    /**
     * Get OverallBalanceForRange value
     * @return float|null
     */
    public function getOverallBalanceForRange()
    {
        return $this->OverallBalanceForRange;
    }
    /**
     * Set OverallBalanceForRange value
     * @param float $overallBalanceForRange
     * @return \StructType\ViewBalanceInfo
     */
    public function setOverallBalanceForRange($overallBalanceForRange = null)
    {
        // validation for constraint: float
        if (!is_null($overallBalanceForRange) && !(is_float($overallBalanceForRange) || is_numeric($overallBalanceForRange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overallBalanceForRange, true), gettype($overallBalanceForRange)), __LINE__);
        }
        $this->OverallBalanceForRange = $overallBalanceForRange;
        return $this;
    }
    /**
     * Get OverallBalanceFromInception value
     * @return float|null
     */
    public function getOverallBalanceFromInception()
    {
        return $this->OverallBalanceFromInception;
    }
    /**
     * Set OverallBalanceFromInception value
     * @param float $overallBalanceFromInception
     * @return \StructType\ViewBalanceInfo
     */
    public function setOverallBalanceFromInception($overallBalanceFromInception = null)
    {
        // validation for constraint: float
        if (!is_null($overallBalanceFromInception) && !(is_float($overallBalanceFromInception) || is_numeric($overallBalanceFromInception))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overallBalanceFromInception, true), gettype($overallBalanceFromInception)), __LINE__);
        }
        $this->OverallBalanceFromInception = $overallBalanceFromInception;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewBalanceInfo
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
