<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveCumulativeBalance StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveCumulativeBalance
 * @subpackage Structs
 */
class RetrieveCumulativeBalance extends TransactionInfo
{
    /**
     * The RetrieveCumulativeBalanceRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveCumulativeBalance
     */
    public $RetrieveCumulativeBalanceRequest;
    /**
     * The IncludeChildAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncludeChildAgent;
    /**
     * Constructor method for RetrieveCumulativeBalance
     * @uses RetrieveCumulativeBalance::setRetrieveCumulativeBalanceRequest()
     * @uses RetrieveCumulativeBalance::setIncludeChildAgent()
     * @param \StructType\RetrieveCumulativeBalance $retrieveCumulativeBalanceRequest
     * @param string $includeChildAgent
     */
    public function __construct(\StructType\RetrieveCumulativeBalance $retrieveCumulativeBalanceRequest = null, $includeChildAgent = null)
    {
        $this
            ->setRetrieveCumulativeBalanceRequest($retrieveCumulativeBalanceRequest)
            ->setIncludeChildAgent($includeChildAgent);
    }
    /**
     * Get RetrieveCumulativeBalanceRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveCumulativeBalance|null
     */
    public function getRetrieveCumulativeBalanceRequest()
    {
        return isset($this->RetrieveCumulativeBalanceRequest) ? $this->RetrieveCumulativeBalanceRequest : null;
    }
    /**
     * Set RetrieveCumulativeBalanceRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveCumulativeBalance $retrieveCumulativeBalanceRequest
     * @return \StructType\RetrieveCumulativeBalance
     */
    public function setRetrieveCumulativeBalanceRequest(\StructType\RetrieveCumulativeBalance $retrieveCumulativeBalanceRequest = null)
    {
        if (is_null($retrieveCumulativeBalanceRequest) || (is_array($retrieveCumulativeBalanceRequest) && empty($retrieveCumulativeBalanceRequest))) {
            unset($this->RetrieveCumulativeBalanceRequest);
        } else {
            $this->RetrieveCumulativeBalanceRequest = $retrieveCumulativeBalanceRequest;
        }
        return $this;
    }
    /**
     * Get IncludeChildAgent value
     * @return string|null
     */
    public function getIncludeChildAgent()
    {
        return $this->IncludeChildAgent;
    }
    /**
     * Set IncludeChildAgent value
     * @uses \EnumType\Enumerations_AnswerTypes::valueIsValid()
     * @uses \EnumType\Enumerations_AnswerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeChildAgent
     * @return \StructType\RetrieveCumulativeBalance
     */
    public function setIncludeChildAgent($includeChildAgent = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_AnswerTypes::valueIsValid($includeChildAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_AnswerTypes', is_array($includeChildAgent) ? implode(', ', $includeChildAgent) : var_export($includeChildAgent, true), implode(', ', \EnumType\Enumerations_AnswerTypes::getValidValues())), __LINE__);
        }
        $this->IncludeChildAgent = $includeChildAgent;
        return $this;
    }
}
