<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfViewFinanceAgents ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfViewFinanceAgents
 * @subpackage Arrays
 */
class ArrayOfViewFinanceAgents extends AbstractStructArrayBase
{
    /**
     * The ViewFinanceAgents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ViewFinanceAgents[]
     */
    public $ViewFinanceAgents;
    /**
     * Constructor method for ArrayOfViewFinanceAgents
     * @uses ArrayOfViewFinanceAgents::setViewFinanceAgents()
     * @param \StructType\ViewFinanceAgents[] $viewFinanceAgents
     */
    public function __construct(array $viewFinanceAgents = array())
    {
        $this
            ->setViewFinanceAgents($viewFinanceAgents);
    }
    /**
     * Get ViewFinanceAgents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ViewFinanceAgents[]|null
     */
    public function getViewFinanceAgents()
    {
        return isset($this->ViewFinanceAgents) ? $this->ViewFinanceAgents : null;
    }
    /**
     * This method is responsible for validating the values passed to the setViewFinanceAgents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setViewFinanceAgents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateViewFinanceAgentsForArrayConstraintsFromSetViewFinanceAgents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfViewFinanceAgentsViewFinanceAgentsItem) {
            // validation for constraint: itemType
            if (!$arrayOfViewFinanceAgentsViewFinanceAgentsItem instanceof \StructType\ViewFinanceAgents) {
                $invalidValues[] = is_object($arrayOfViewFinanceAgentsViewFinanceAgentsItem) ? get_class($arrayOfViewFinanceAgentsViewFinanceAgentsItem) : sprintf('%s(%s)', gettype($arrayOfViewFinanceAgentsViewFinanceAgentsItem), var_export($arrayOfViewFinanceAgentsViewFinanceAgentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ViewFinanceAgents property can only contain items of type \StructType\ViewFinanceAgents, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ViewFinanceAgents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ViewFinanceAgents[] $viewFinanceAgents
     * @return \ArrayType\ArrayOfViewFinanceAgents
     */
    public function setViewFinanceAgents(array $viewFinanceAgents = array())
    {
        // validation for constraint: array
        if ('' !== ($viewFinanceAgentsArrayErrorMessage = self::validateViewFinanceAgentsForArrayConstraintsFromSetViewFinanceAgents($viewFinanceAgents))) {
            throw new \InvalidArgumentException($viewFinanceAgentsArrayErrorMessage, __LINE__);
        }
        if (is_null($viewFinanceAgents) || (is_array($viewFinanceAgents) && empty($viewFinanceAgents))) {
            unset($this->ViewFinanceAgents);
        } else {
            $this->ViewFinanceAgents = $viewFinanceAgents;
        }
        return $this;
    }
    /**
     * Add item to ViewFinanceAgents value
     * @throws \InvalidArgumentException
     * @param \StructType\ViewFinanceAgents $item
     * @return \ArrayType\ArrayOfViewFinanceAgents
     */
    public function addToViewFinanceAgents(\StructType\ViewFinanceAgents $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ViewFinanceAgents) {
            throw new \InvalidArgumentException(sprintf('The ViewFinanceAgents property can only contain items of type \StructType\ViewFinanceAgents, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ViewFinanceAgents[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ViewFinanceAgents|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ViewFinanceAgents|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ViewFinanceAgents|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ViewFinanceAgents|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ViewFinanceAgents|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ViewFinanceAgents
     */
    public function getAttributeName()
    {
        return 'ViewFinanceAgents';
    }
}
