<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvanceSeating StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdvanceSeating
 * @subpackage Structs
 */
class AdvanceSeating extends TransactionInfo
{
    /**
     * The AdvanceSeatingRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdvanceSeating
     */
    public $AdvanceSeatingRequest;
    /**
     * The Passengers
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfPassenger
     */
    public $Passengers;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for AdvanceSeating
     * @uses AdvanceSeating::setAdvanceSeatingRequest()
     * @uses AdvanceSeating::setPassengers()
     * @uses AdvanceSeating::setExceptions()
     * @param \StructType\AdvanceSeating $advanceSeatingRequest
     * @param \ArrayType\ArrayOfPassenger $passengers
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\AdvanceSeating $advanceSeatingRequest = null, \ArrayType\ArrayOfPassenger $passengers = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setAdvanceSeatingRequest($advanceSeatingRequest)
            ->setPassengers($passengers)
            ->setExceptions($exceptions);
    }
    /**
     * Get AdvanceSeatingRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdvanceSeating|null
     */
    public function getAdvanceSeatingRequest()
    {
        return isset($this->AdvanceSeatingRequest) ? $this->AdvanceSeatingRequest : null;
    }
    /**
     * Set AdvanceSeatingRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdvanceSeating $advanceSeatingRequest
     * @return \StructType\AdvanceSeating
     */
    public function setAdvanceSeatingRequest(\StructType\AdvanceSeating $advanceSeatingRequest = null)
    {
        if (is_null($advanceSeatingRequest) || (is_array($advanceSeatingRequest) && empty($advanceSeatingRequest))) {
            unset($this->AdvanceSeatingRequest);
        } else {
            $this->AdvanceSeatingRequest = $advanceSeatingRequest;
        }
        return $this;
    }
    /**
     * Get Passengers value
     * @return \ArrayType\ArrayOfPassenger|null
     */
    public function getPassengers()
    {
        return $this->Passengers;
    }
    /**
     * Set Passengers value
     * @param \ArrayType\ArrayOfPassenger $passengers
     * @return \StructType\AdvanceSeating
     */
    public function setPassengers(\ArrayType\ArrayOfPassenger $passengers = null)
    {
        $this->Passengers = $passengers;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\AdvanceSeating
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
