<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.Seating.svc?singleWSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.Seating.svc?singleWSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Advance ServiceType
 */
$advance = new \ServiceType\Advance($options);
/**
 * Sample call for AdvanceSeating operation/method
 */
if ($advance->AdvanceSeating(new \StructType\AdvanceSeating()) !== false) {
    print_r($advance->getResult());
} else {
    print_r($advance->getLastError());
}
/**
 * Samples for Seat ServiceType
 */
$seat = new \ServiceType\Seat($options);
/**
 * Sample call for SeatAssignment operation/method
 */
if ($seat->SeatAssignment(new \StructType\SeatAssignment()) !== false) {
    print_r($seat->getResult());
} else {
    print_r($seat->getLastError());
}
/**
 * Samples for Train ServiceType
 */
$train = new \ServiceType\Train($options);
/**
 * Sample call for TrainSeatAssignment operation/method
 */
if ($train->TrainSeatAssignment(new \StructType\TrainSeatAssignment()) !== false) {
    print_r($train->getResult());
} else {
    print_r($train->getLastError());
}
