<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrainSeatAssignmentDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TrainSeatAssignmentDetail
 * @subpackage Structs
 */
class TrainSeatAssignmentDetail extends AbstractStructBase
{
    /**
     * The LogicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The PersonOrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonOrgID;
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The RailCarID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RailCarID;
    /**
     * The RecordNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecordNumber;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RowNumber;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * Constructor method for TrainSeatAssignmentDetail
     * @uses TrainSeatAssignmentDetail::setLogicalFlightID()
     * @uses TrainSeatAssignmentDetail::setPersonOrgID()
     * @uses TrainSeatAssignmentDetail::setPhysicalFlightID()
     * @uses TrainSeatAssignmentDetail::setRailCarID()
     * @uses TrainSeatAssignmentDetail::setRecordNumber()
     * @uses TrainSeatAssignmentDetail::setRowNumber()
     * @uses TrainSeatAssignmentDetail::setSeat()
     * @param int $logicalFlightID
     * @param int $personOrgID
     * @param int $physicalFlightID
     * @param int $railCarID
     * @param int $recordNumber
     * @param int $rowNumber
     * @param string $seat
     */
    public function __construct($logicalFlightID = null, $personOrgID = null, $physicalFlightID = null, $railCarID = null, $recordNumber = null, $rowNumber = null, $seat = null)
    {
        $this
            ->setLogicalFlightID($logicalFlightID)
            ->setPersonOrgID($personOrgID)
            ->setPhysicalFlightID($physicalFlightID)
            ->setRailCarID($railCarID)
            ->setRecordNumber($recordNumber)
            ->setRowNumber($rowNumber)
            ->setSeat($seat);
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\TrainSeatAssignmentDetail
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\TrainSeatAssignmentDetail
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param int $physicalFlightID
     * @return \StructType\TrainSeatAssignmentDetail
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID;
        return $this;
    }
    /**
     * Get RailCarID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRailCarID()
    {
        return isset($this->RailCarID) ? $this->RailCarID : null;
    }
    /**
     * Set RailCarID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $railCarID
     * @return \StructType\TrainSeatAssignmentDetail
     */
    public function setRailCarID($railCarID = null)
    {
        // validation for constraint: int
        if (!is_null($railCarID) && !(is_int($railCarID) || ctype_digit($railCarID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($railCarID, true), gettype($railCarID)), __LINE__);
        }
        if (is_null($railCarID) || (is_array($railCarID) && empty($railCarID))) {
            unset($this->RailCarID);
        } else {
            $this->RailCarID = $railCarID;
        }
        return $this;
    }
    /**
     * Get RecordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->RecordNumber;
    }
    /**
     * Set RecordNumber value
     * @param int $recordNumber
     * @return \StructType\TrainSeatAssignmentDetail
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->RecordNumber = $recordNumber;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\TrainSeatAssignmentDetail
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seat
     * @return \StructType\TrainSeatAssignmentDetail
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
}
