<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrainSeatAssignment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TrainSeatAssignment
 * @subpackage Structs
 */
class TrainSeatAssignment extends TransactionInfo
{
    /**
     * The TrainSeatAssignmentRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TrainSeatAssignment
     */
    public $TrainSeatAssignmentRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The TrainSeatAssignmentDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfTrainSeatAssignmentDetail
     */
    public $TrainSeatAssignmentDetails;
    /**
     * Constructor method for TrainSeatAssignment
     * @uses TrainSeatAssignment::setTrainSeatAssignmentRequest()
     * @uses TrainSeatAssignment::setActionType()
     * @uses TrainSeatAssignment::setReservationInfo()
     * @uses TrainSeatAssignment::setTrainSeatAssignmentDetails()
     * @param \StructType\TrainSeatAssignment $trainSeatAssignmentRequest
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param \ArrayType\ArrayOfTrainSeatAssignmentDetail $trainSeatAssignmentDetails
     */
    public function __construct(\StructType\TrainSeatAssignment $trainSeatAssignmentRequest = null, $actionType = null, \StructType\ReservationInfo $reservationInfo = null, \ArrayType\ArrayOfTrainSeatAssignmentDetail $trainSeatAssignmentDetails = null)
    {
        $this
            ->setTrainSeatAssignmentRequest($trainSeatAssignmentRequest)
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setTrainSeatAssignmentDetails($trainSeatAssignmentDetails);
    }
    /**
     * Get TrainSeatAssignmentRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TrainSeatAssignment|null
     */
    public function getTrainSeatAssignmentRequest()
    {
        return isset($this->TrainSeatAssignmentRequest) ? $this->TrainSeatAssignmentRequest : null;
    }
    /**
     * Set TrainSeatAssignmentRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TrainSeatAssignment $trainSeatAssignmentRequest
     * @return \StructType\TrainSeatAssignment
     */
    public function setTrainSeatAssignmentRequest(\StructType\TrainSeatAssignment $trainSeatAssignmentRequest = null)
    {
        if (is_null($trainSeatAssignmentRequest) || (is_array($trainSeatAssignmentRequest) && empty($trainSeatAssignmentRequest))) {
            unset($this->TrainSeatAssignmentRequest);
        } else {
            $this->TrainSeatAssignmentRequest = $trainSeatAssignmentRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\PassengerSeatAssignment_ActionTypes::valueIsValid()
     * @uses \EnumType\PassengerSeatAssignment_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\TrainSeatAssignment
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PassengerSeatAssignment_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PassengerSeatAssignment_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\PassengerSeatAssignment_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\TrainSeatAssignment
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get TrainSeatAssignmentDetails value
     * @return \ArrayType\ArrayOfTrainSeatAssignmentDetail|null
     */
    public function getTrainSeatAssignmentDetails()
    {
        return $this->TrainSeatAssignmentDetails;
    }
    /**
     * Set TrainSeatAssignmentDetails value
     * @param \ArrayType\ArrayOfTrainSeatAssignmentDetail $trainSeatAssignmentDetails
     * @return \StructType\TrainSeatAssignment
     */
    public function setTrainSeatAssignmentDetails(\ArrayType\ArrayOfTrainSeatAssignmentDetail $trainSeatAssignmentDetails = null)
    {
        $this->TrainSeatAssignmentDetails = $trainSeatAssignmentDetails;
        return $this;
    }
}
