<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerSeatAssignment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerSeatAssignment
 * @subpackage Structs
 */
class PassengerSeatAssignment extends TransactionInfo
{
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The SeatAssignmentDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatAssignmentDetail
     */
    public $SeatAssignmentDetails;
    /**
     * Constructor method for PassengerSeatAssignment
     * @uses PassengerSeatAssignment::setActionType()
     * @uses PassengerSeatAssignment::setReservationInfo()
     * @uses PassengerSeatAssignment::setSeatAssignmentDetails()
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param \ArrayType\ArrayOfSeatAssignmentDetail $seatAssignmentDetails
     */
    public function __construct($actionType = null, \StructType\ReservationInfo $reservationInfo = null, \ArrayType\ArrayOfSeatAssignmentDetail $seatAssignmentDetails = null)
    {
        $this
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setSeatAssignmentDetails($seatAssignmentDetails);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\PassengerSeatAssignment_ActionTypes::valueIsValid()
     * @uses \EnumType\PassengerSeatAssignment_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\PassengerSeatAssignment
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PassengerSeatAssignment_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PassengerSeatAssignment_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\PassengerSeatAssignment_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\PassengerSeatAssignment
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get SeatAssignmentDetails value
     * @return \ArrayType\ArrayOfSeatAssignmentDetail|null
     */
    public function getSeatAssignmentDetails()
    {
        return $this->SeatAssignmentDetails;
    }
    /**
     * Set SeatAssignmentDetails value
     * @param \ArrayType\ArrayOfSeatAssignmentDetail $seatAssignmentDetails
     * @return \StructType\PassengerSeatAssignment
     */
    public function setSeatAssignmentDetails(\ArrayType\ArrayOfSeatAssignmentDetail $seatAssignmentDetails = null)
    {
        $this->SeatAssignmentDetails = $seatAssignmentDetails;
        return $this;
    }
}
