<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airline StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Airline
 * @subpackage Structs
 */
class Airline extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The LogicalFlight
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfLogicalFlight
     */
    public $LogicalFlight;
    /**
     * The OAFlights
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfOAFlight
     */
    public $OAFlights;
    /**
     * Constructor method for Airline
     * @uses Airline::setKey()
     * @uses Airline::setLogicalFlight()
     * @uses Airline::setOAFlights()
     * @param string $key
     * @param \ArrayType\ArrayOfLogicalFlight $logicalFlight
     * @param \ArrayType\ArrayOfOAFlight $oAFlights
     */
    public function __construct($key = null, \ArrayType\ArrayOfLogicalFlight $logicalFlight = null, \ArrayType\ArrayOfOAFlight $oAFlights = null)
    {
        $this
            ->setKey($key)
            ->setLogicalFlight($logicalFlight)
            ->setOAFlights($oAFlights);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\Airline
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get LogicalFlight value
     * @return \ArrayType\ArrayOfLogicalFlight|null
     */
    public function getLogicalFlight()
    {
        return $this->LogicalFlight;
    }
    /**
     * Set LogicalFlight value
     * @param \ArrayType\ArrayOfLogicalFlight $logicalFlight
     * @return \StructType\Airline
     */
    public function setLogicalFlight(\ArrayType\ArrayOfLogicalFlight $logicalFlight = null)
    {
        $this->LogicalFlight = $logicalFlight;
        return $this;
    }
    /**
     * Get OAFlights value
     * @return \ArrayType\ArrayOfOAFlight|null
     */
    public function getOAFlights()
    {
        return $this->OAFlights;
    }
    /**
     * Set OAFlights value
     * @param \ArrayType\ArrayOfOAFlight $oAFlights
     * @return \StructType\Airline
     */
    public function setOAFlights(\ArrayType\ArrayOfOAFlight $oAFlights = null)
    {
        $this->OAFlights = $oAFlights;
        return $this;
    }
}
