<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReservationPaymentMap ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfReservationPaymentMap
 * @subpackage Arrays
 */
class ArrayOfReservationPaymentMap extends AbstractStructArrayBase
{
    /**
     * The ReservationPaymentMap
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReservationPaymentMap[]
     */
    public $ReservationPaymentMap;
    /**
     * Constructor method for ArrayOfReservationPaymentMap
     * @uses ArrayOfReservationPaymentMap::setReservationPaymentMap()
     * @param \StructType\ReservationPaymentMap[] $reservationPaymentMap
     */
    public function __construct(array $reservationPaymentMap = array())
    {
        $this
            ->setReservationPaymentMap($reservationPaymentMap);
    }
    /**
     * Get ReservationPaymentMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReservationPaymentMap[]|null
     */
    public function getReservationPaymentMap()
    {
        return isset($this->ReservationPaymentMap) ? $this->ReservationPaymentMap : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReservationPaymentMap method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReservationPaymentMap method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReservationPaymentMapForArrayConstraintsFromSetReservationPaymentMap(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfReservationPaymentMapReservationPaymentMapItem) {
            // validation for constraint: itemType
            if (!$arrayOfReservationPaymentMapReservationPaymentMapItem instanceof \StructType\ReservationPaymentMap) {
                $invalidValues[] = is_object($arrayOfReservationPaymentMapReservationPaymentMapItem) ? get_class($arrayOfReservationPaymentMapReservationPaymentMapItem) : sprintf('%s(%s)', gettype($arrayOfReservationPaymentMapReservationPaymentMapItem), var_export($arrayOfReservationPaymentMapReservationPaymentMapItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReservationPaymentMap property can only contain items of type \StructType\ReservationPaymentMap, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReservationPaymentMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReservationPaymentMap[] $reservationPaymentMap
     * @return \ArrayType\ArrayOfReservationPaymentMap
     */
    public function setReservationPaymentMap(array $reservationPaymentMap = array())
    {
        // validation for constraint: array
        if ('' !== ($reservationPaymentMapArrayErrorMessage = self::validateReservationPaymentMapForArrayConstraintsFromSetReservationPaymentMap($reservationPaymentMap))) {
            throw new \InvalidArgumentException($reservationPaymentMapArrayErrorMessage, __LINE__);
        }
        if (is_null($reservationPaymentMap) || (is_array($reservationPaymentMap) && empty($reservationPaymentMap))) {
            unset($this->ReservationPaymentMap);
        } else {
            $this->ReservationPaymentMap = $reservationPaymentMap;
        }
        return $this;
    }
    /**
     * Add item to ReservationPaymentMap value
     * @throws \InvalidArgumentException
     * @param \StructType\ReservationPaymentMap $item
     * @return \ArrayType\ArrayOfReservationPaymentMap
     */
    public function addToReservationPaymentMap(\StructType\ReservationPaymentMap $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReservationPaymentMap) {
            throw new \InvalidArgumentException(sprintf('The ReservationPaymentMap property can only contain items of type \StructType\ReservationPaymentMap, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReservationPaymentMap[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ReservationPaymentMap|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ReservationPaymentMap|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ReservationPaymentMap|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ReservationPaymentMap|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ReservationPaymentMap|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReservationPaymentMap
     */
    public function getAttributeName()
    {
        return 'ReservationPaymentMap';
    }
}
