<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatAssignmentDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatAssignmentDetail
 * @subpackage Structs
 */
class SeatAssignmentDetail extends AbstractStructBase
{
    /**
     * The ReservationKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ReservationKey;
    /**
     * The LogicalFlightKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogicalFlightKey;
    /**
     * The PhysicalFlightKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PhysicalFlightKey;
    /**
     * The CustomerKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CustomerKey;
    /**
     * The AirLinePersonKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AirLinePersonKey;
    /**
     * The SeatAssignmentKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeatAssignmentKey;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RowNumber;
    /**
     * The OldSeat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OldSeat;
    /**
     * The OldRowNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OldRowNumber;
    /**
     * The IsExtraSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExtraSeat;
    /**
     * Constructor method for SeatAssignmentDetail
     * @uses SeatAssignmentDetail::setReservationKey()
     * @uses SeatAssignmentDetail::setLogicalFlightKey()
     * @uses SeatAssignmentDetail::setPhysicalFlightKey()
     * @uses SeatAssignmentDetail::setCustomerKey()
     * @uses SeatAssignmentDetail::setAirLinePersonKey()
     * @uses SeatAssignmentDetail::setSeatAssignmentKey()
     * @uses SeatAssignmentDetail::setSeat()
     * @uses SeatAssignmentDetail::setRowNumber()
     * @uses SeatAssignmentDetail::setOldSeat()
     * @uses SeatAssignmentDetail::setOldRowNumber()
     * @uses SeatAssignmentDetail::setIsExtraSeat()
     * @param string $reservationKey
     * @param string $logicalFlightKey
     * @param string $physicalFlightKey
     * @param string $customerKey
     * @param string $airLinePersonKey
     * @param string $seatAssignmentKey
     * @param string $seat
     * @param string $rowNumber
     * @param string $oldSeat
     * @param string $oldRowNumber
     * @param bool $isExtraSeat
     */
    public function __construct($reservationKey = null, $logicalFlightKey = null, $physicalFlightKey = null, $customerKey = null, $airLinePersonKey = null, $seatAssignmentKey = null, $seat = null, $rowNumber = null, $oldSeat = null, $oldRowNumber = null, $isExtraSeat = null)
    {
        $this
            ->setReservationKey($reservationKey)
            ->setLogicalFlightKey($logicalFlightKey)
            ->setPhysicalFlightKey($physicalFlightKey)
            ->setCustomerKey($customerKey)
            ->setAirLinePersonKey($airLinePersonKey)
            ->setSeatAssignmentKey($seatAssignmentKey)
            ->setSeat($seat)
            ->setRowNumber($rowNumber)
            ->setOldSeat($oldSeat)
            ->setOldRowNumber($oldRowNumber)
            ->setIsExtraSeat($isExtraSeat);
    }
    /**
     * Get ReservationKey value
     * @return string|null
     */
    public function getReservationKey()
    {
        return $this->ReservationKey;
    }
    /**
     * Set ReservationKey value
     * @param string $reservationKey
     * @return \StructType\SeatAssignmentDetail
     */
    public function setReservationKey($reservationKey = null)
    {
        // validation for constraint: string
        if (!is_null($reservationKey) && !is_string($reservationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationKey, true), gettype($reservationKey)), __LINE__);
        }
        $this->ReservationKey = $reservationKey;
        return $this;
    }
    /**
     * Get LogicalFlightKey value
     * @return string|null
     */
    public function getLogicalFlightKey()
    {
        return $this->LogicalFlightKey;
    }
    /**
     * Set LogicalFlightKey value
     * @param string $logicalFlightKey
     * @return \StructType\SeatAssignmentDetail
     */
    public function setLogicalFlightKey($logicalFlightKey = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightKey) && !is_string($logicalFlightKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightKey, true), gettype($logicalFlightKey)), __LINE__);
        }
        $this->LogicalFlightKey = $logicalFlightKey;
        return $this;
    }
    /**
     * Get PhysicalFlightKey value
     * @return string|null
     */
    public function getPhysicalFlightKey()
    {
        return $this->PhysicalFlightKey;
    }
    /**
     * Set PhysicalFlightKey value
     * @param string $physicalFlightKey
     * @return \StructType\SeatAssignmentDetail
     */
    public function setPhysicalFlightKey($physicalFlightKey = null)
    {
        // validation for constraint: string
        if (!is_null($physicalFlightKey) && !is_string($physicalFlightKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalFlightKey, true), gettype($physicalFlightKey)), __LINE__);
        }
        $this->PhysicalFlightKey = $physicalFlightKey;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\SeatAssignmentDetail
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKey, true), gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get AirLinePersonKey value
     * @return string|null
     */
    public function getAirLinePersonKey()
    {
        return $this->AirLinePersonKey;
    }
    /**
     * Set AirLinePersonKey value
     * @param string $airLinePersonKey
     * @return \StructType\SeatAssignmentDetail
     */
    public function setAirLinePersonKey($airLinePersonKey = null)
    {
        // validation for constraint: string
        if (!is_null($airLinePersonKey) && !is_string($airLinePersonKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airLinePersonKey, true), gettype($airLinePersonKey)), __LINE__);
        }
        $this->AirLinePersonKey = $airLinePersonKey;
        return $this;
    }
    /**
     * Get SeatAssignmentKey value
     * @return string|null
     */
    public function getSeatAssignmentKey()
    {
        return $this->SeatAssignmentKey;
    }
    /**
     * Set SeatAssignmentKey value
     * @param string $seatAssignmentKey
     * @return \StructType\SeatAssignmentDetail
     */
    public function setSeatAssignmentKey($seatAssignmentKey = null)
    {
        // validation for constraint: string
        if (!is_null($seatAssignmentKey) && !is_string($seatAssignmentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatAssignmentKey, true), gettype($seatAssignmentKey)), __LINE__);
        }
        $this->SeatAssignmentKey = $seatAssignmentKey;
        return $this;
    }
    /**
     * Get Seat value
     * @return string|null
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * Set Seat value
     * @param string $seat
     * @return \StructType\SeatAssignmentDetail
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return string|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param string $rowNumber
     * @return \StructType\SeatAssignmentDetail
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: string
        if (!is_null($rowNumber) && !is_string($rowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get OldSeat value
     * @return string|null
     */
    public function getOldSeat()
    {
        return $this->OldSeat;
    }
    /**
     * Set OldSeat value
     * @param string $oldSeat
     * @return \StructType\SeatAssignmentDetail
     */
    public function setOldSeat($oldSeat = null)
    {
        // validation for constraint: string
        if (!is_null($oldSeat) && !is_string($oldSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldSeat, true), gettype($oldSeat)), __LINE__);
        }
        $this->OldSeat = $oldSeat;
        return $this;
    }
    /**
     * Get OldRowNumber value
     * @return string|null
     */
    public function getOldRowNumber()
    {
        return $this->OldRowNumber;
    }
    /**
     * Set OldRowNumber value
     * @param string $oldRowNumber
     * @return \StructType\SeatAssignmentDetail
     */
    public function setOldRowNumber($oldRowNumber = null)
    {
        // validation for constraint: string
        if (!is_null($oldRowNumber) && !is_string($oldRowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldRowNumber, true), gettype($oldRowNumber)), __LINE__);
        }
        $this->OldRowNumber = $oldRowNumber;
        return $this;
    }
    /**
     * Get IsExtraSeat value
     * @return bool|null
     */
    public function getIsExtraSeat()
    {
        return $this->IsExtraSeat;
    }
    /**
     * Set IsExtraSeat value
     * @param bool $isExtraSeat
     * @return \StructType\SeatAssignmentDetail
     */
    public function setIsExtraSeat($isExtraSeat = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExtraSeat) && !is_bool($isExtraSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExtraSeat, true), gettype($isExtraSeat)), __LINE__);
        }
        $this->IsExtraSeat = $isExtraSeat;
        return $this;
    }
}
