<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Seat StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Seat
 * @subpackage Structs
 */
class Seat extends AbstractStructBase
{
    /**
     * The SeatHeldID
     * @var int
     */
    public $SeatHeldID;
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The PhysicalFlightID
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The ActualDepartDate
     * @var string
     */
    public $ActualDepartDate;
    /**
     * The FareClass
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareClass;
    /**
     * The SeatRow
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeatRow;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The Action
     * @var string
     */
    public $Action;
    /**
     * The RecordNumber
     * @var int
     */
    public $RecordNumber;
    /**
     * The AssociatedSegmentID
     * @var int
     */
    public $AssociatedSegmentID;
    /**
     * The HeldStatus
     * @var string
     */
    public $HeldStatus;
    /**
     * The ActionResult
     * @var string
     */
    public $ActionResult;
    /**
     * The HoldExpiration
     * @var string
     */
    public $HoldExpiration;
    /**
     * The IsDirty
     * @var bool
     */
    public $IsDirty;
    /**
     * The RailCarID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RailCarID;
    /**
     * Constructor method for Seat
     * @uses Seat::setSeatHeldID()
     * @uses Seat::setSeriesNumber()
     * @uses Seat::setConfirmationNumber()
     * @uses Seat::setPhysicalFlightID()
     * @uses Seat::setActualDepartDate()
     * @uses Seat::setFareClass()
     * @uses Seat::setSeatRow()
     * @uses Seat::setSeat()
     * @uses Seat::setAction()
     * @uses Seat::setRecordNumber()
     * @uses Seat::setAssociatedSegmentID()
     * @uses Seat::setHeldStatus()
     * @uses Seat::setActionResult()
     * @uses Seat::setHoldExpiration()
     * @uses Seat::setIsDirty()
     * @uses Seat::setRailCarID()
     * @param int $seatHeldID
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param int $physicalFlightID
     * @param string $actualDepartDate
     * @param string $fareClass
     * @param string $seatRow
     * @param string $seat
     * @param string $action
     * @param int $recordNumber
     * @param int $associatedSegmentID
     * @param string $heldStatus
     * @param string $actionResult
     * @param string $holdExpiration
     * @param bool $isDirty
     * @param int $railCarID
     */
    public function __construct($seatHeldID = null, $seriesNumber = null, $confirmationNumber = null, $physicalFlightID = null, $actualDepartDate = null, $fareClass = null, $seatRow = null, $seat = null, $action = null, $recordNumber = null, $associatedSegmentID = null, $heldStatus = null, $actionResult = null, $holdExpiration = null, $isDirty = null, $railCarID = null)
    {
        $this
            ->setSeatHeldID($seatHeldID)
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setPhysicalFlightID($physicalFlightID)
            ->setActualDepartDate($actualDepartDate)
            ->setFareClass($fareClass)
            ->setSeatRow($seatRow)
            ->setSeat($seat)
            ->setAction($action)
            ->setRecordNumber($recordNumber)
            ->setAssociatedSegmentID($associatedSegmentID)
            ->setHeldStatus($heldStatus)
            ->setActionResult($actionResult)
            ->setHoldExpiration($holdExpiration)
            ->setIsDirty($isDirty)
            ->setRailCarID($railCarID);
    }
    /**
     * Get SeatHeldID value
     * @return int|null
     */
    public function getSeatHeldID()
    {
        return $this->SeatHeldID;
    }
    /**
     * Set SeatHeldID value
     * @param int $seatHeldID
     * @return \StructType\Seat
     */
    public function setSeatHeldID($seatHeldID = null)
    {
        // validation for constraint: int
        if (!is_null($seatHeldID) && !(is_int($seatHeldID) || ctype_digit($seatHeldID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatHeldID, true), gettype($seatHeldID)), __LINE__);
        }
        $this->SeatHeldID = $seatHeldID;
        return $this;
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\Seat
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\Seat
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param int $physicalFlightID
     * @return \StructType\Seat
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID;
        return $this;
    }
    /**
     * Get ActualDepartDate value
     * @return string|null
     */
    public function getActualDepartDate()
    {
        return $this->ActualDepartDate;
    }
    /**
     * Set ActualDepartDate value
     * @param string $actualDepartDate
     * @return \StructType\Seat
     */
    public function setActualDepartDate($actualDepartDate = null)
    {
        // validation for constraint: string
        if (!is_null($actualDepartDate) && !is_string($actualDepartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualDepartDate, true), gettype($actualDepartDate)), __LINE__);
        }
        $this->ActualDepartDate = $actualDepartDate;
        return $this;
    }
    /**
     * Get FareClass value
     * @return string|null
     */
    public function getFareClass()
    {
        return $this->FareClass;
    }
    /**
     * Set FareClass value
     * @param string $fareClass
     * @return \StructType\Seat
     */
    public function setFareClass($fareClass = null)
    {
        // validation for constraint: string
        if (!is_null($fareClass) && !is_string($fareClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareClass, true), gettype($fareClass)), __LINE__);
        }
        $this->FareClass = $fareClass;
        return $this;
    }
    /**
     * Get SeatRow value
     * @return string|null
     */
    public function getSeatRow()
    {
        return $this->SeatRow;
    }
    /**
     * Set SeatRow value
     * @param string $seatRow
     * @return \StructType\Seat
     */
    public function setSeatRow($seatRow = null)
    {
        // validation for constraint: string
        if (!is_null($seatRow) && !is_string($seatRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatRow, true), gettype($seatRow)), __LINE__);
        }
        $this->SeatRow = $seatRow;
        return $this;
    }
    /**
     * Get Seat value
     * @return string|null
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * Set Seat value
     * @param string $seat
     * @return \StructType\Seat
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\Enumerations_Actions::valueIsValid()
     * @uses \EnumType\Enumerations_Actions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\Seat
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_Actions::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_Actions', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\Enumerations_Actions::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get RecordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->RecordNumber;
    }
    /**
     * Set RecordNumber value
     * @param int $recordNumber
     * @return \StructType\Seat
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->RecordNumber = $recordNumber;
        return $this;
    }
    /**
     * Get AssociatedSegmentID value
     * @return int|null
     */
    public function getAssociatedSegmentID()
    {
        return $this->AssociatedSegmentID;
    }
    /**
     * Set AssociatedSegmentID value
     * @param int $associatedSegmentID
     * @return \StructType\Seat
     */
    public function setAssociatedSegmentID($associatedSegmentID = null)
    {
        // validation for constraint: int
        if (!is_null($associatedSegmentID) && !(is_int($associatedSegmentID) || ctype_digit($associatedSegmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($associatedSegmentID, true), gettype($associatedSegmentID)), __LINE__);
        }
        $this->AssociatedSegmentID = $associatedSegmentID;
        return $this;
    }
    /**
     * Get HeldStatus value
     * @return string|null
     */
    public function getHeldStatus()
    {
        return $this->HeldStatus;
    }
    /**
     * Set HeldStatus value
     * @uses \EnumType\Enumerations_HeldStatuses::valueIsValid()
     * @uses \EnumType\Enumerations_HeldStatuses::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $heldStatus
     * @return \StructType\Seat
     */
    public function setHeldStatus($heldStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_HeldStatuses::valueIsValid($heldStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_HeldStatuses', is_array($heldStatus) ? implode(', ', $heldStatus) : var_export($heldStatus, true), implode(', ', \EnumType\Enumerations_HeldStatuses::getValidValues())), __LINE__);
        }
        $this->HeldStatus = $heldStatus;
        return $this;
    }
    /**
     * Get ActionResult value
     * @return string|null
     */
    public function getActionResult()
    {
        return $this->ActionResult;
    }
    /**
     * Set ActionResult value
     * @uses \EnumType\Enumerations_ActionResults::valueIsValid()
     * @uses \EnumType\Enumerations_ActionResults::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionResult
     * @return \StructType\Seat
     */
    public function setActionResult($actionResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_ActionResults::valueIsValid($actionResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_ActionResults', is_array($actionResult) ? implode(', ', $actionResult) : var_export($actionResult, true), implode(', ', \EnumType\Enumerations_ActionResults::getValidValues())), __LINE__);
        }
        $this->ActionResult = $actionResult;
        return $this;
    }
    /**
     * Get HoldExpiration value
     * @return string|null
     */
    public function getHoldExpiration()
    {
        return $this->HoldExpiration;
    }
    /**
     * Set HoldExpiration value
     * @param string $holdExpiration
     * @return \StructType\Seat
     */
    public function setHoldExpiration($holdExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($holdExpiration) && !is_string($holdExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdExpiration, true), gettype($holdExpiration)), __LINE__);
        }
        $this->HoldExpiration = $holdExpiration;
        return $this;
    }
    /**
     * Get IsDirty value
     * @return bool|null
     */
    public function getIsDirty()
    {
        return $this->IsDirty;
    }
    /**
     * Set IsDirty value
     * @param bool $isDirty
     * @return \StructType\Seat
     */
    public function setIsDirty($isDirty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDirty) && !is_bool($isDirty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDirty, true), gettype($isDirty)), __LINE__);
        }
        $this->IsDirty = $isDirty;
        return $this;
    }
    /**
     * Get RailCarID value
     * @return int|null
     */
    public function getRailCarID()
    {
        return $this->RailCarID;
    }
    /**
     * Set RailCarID value
     * @param int $railCarID
     * @return \StructType\Seat
     */
    public function setRailCarID($railCarID = null)
    {
        // validation for constraint: int
        if (!is_null($railCarID) && !(is_int($railCarID) || ctype_digit($railCarID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($railCarID, true), gettype($railCarID)), __LINE__);
        }
        $this->RailCarID = $railCarID;
        return $this;
    }
}
