<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Passenger StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Passenger
 * @subpackage Structs
 */
class Passenger extends Person
{
    /**
     * The IsPrimaryTraveler
     * @var bool
     */
    public $IsPrimaryTraveler;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSeat
     */
    public $Seats;
    /**
     * Constructor method for Passenger
     * @uses Passenger::setIsPrimaryTraveler()
     * @uses Passenger::setSeats()
     * @param bool $isPrimaryTraveler
     * @param \ArrayType\ArrayOfSeat $seats
     */
    public function __construct($isPrimaryTraveler = null, \ArrayType\ArrayOfSeat $seats = null)
    {
        $this
            ->setIsPrimaryTraveler($isPrimaryTraveler)
            ->setSeats($seats);
    }
    /**
     * Get IsPrimaryTraveler value
     * @return bool|null
     */
    public function getIsPrimaryTraveler()
    {
        return $this->IsPrimaryTraveler;
    }
    /**
     * Set IsPrimaryTraveler value
     * @param bool $isPrimaryTraveler
     * @return \StructType\Passenger
     */
    public function setIsPrimaryTraveler($isPrimaryTraveler = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimaryTraveler) && !is_bool($isPrimaryTraveler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimaryTraveler, true), gettype($isPrimaryTraveler)), __LINE__);
        }
        $this->IsPrimaryTraveler = $isPrimaryTraveler;
        return $this;
    }
    /**
     * Get Seats value
     * @return \ArrayType\ArrayOfSeat|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param \ArrayType\ArrayOfSeat $seats
     * @return \StructType\Passenger
     */
    public function setSeats(\ArrayType\ArrayOfSeat $seats = null)
    {
        $this->Seats = $seats;
        return $this;
    }
}
