<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCar ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCar
 * @subpackage Arrays
 */
class ArrayOfCar extends AbstractStructArrayBase
{
    /**
     * The Car
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Car[]
     */
    public $Car;
    /**
     * Constructor method for ArrayOfCar
     * @uses ArrayOfCar::setCar()
     * @param \StructType\Car[] $car
     */
    public function __construct(array $car = array())
    {
        $this
            ->setCar($car);
    }
    /**
     * Get Car value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Car[]|null
     */
    public function getCar()
    {
        return isset($this->Car) ? $this->Car : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarForArrayConstraintsFromSetCar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCarCarItem) {
            // validation for constraint: itemType
            if (!$arrayOfCarCarItem instanceof \StructType\Car) {
                $invalidValues[] = is_object($arrayOfCarCarItem) ? get_class($arrayOfCarCarItem) : sprintf('%s(%s)', gettype($arrayOfCarCarItem), var_export($arrayOfCarCarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Car property can only contain items of type \StructType\Car, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Car value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Car[] $car
     * @return \ArrayType\ArrayOfCar
     */
    public function setCar(array $car = array())
    {
        // validation for constraint: array
        if ('' !== ($carArrayErrorMessage = self::validateCarForArrayConstraintsFromSetCar($car))) {
            throw new \InvalidArgumentException($carArrayErrorMessage, __LINE__);
        }
        if (is_null($car) || (is_array($car) && empty($car))) {
            unset($this->Car);
        } else {
            $this->Car = $car;
        }
        return $this;
    }
    /**
     * Add item to Car value
     * @throws \InvalidArgumentException
     * @param \StructType\Car $item
     * @return \ArrayType\ArrayOfCar
     */
    public function addToCar(\StructType\Car $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Car) {
            throw new \InvalidArgumentException(sprintf('The Car property can only contain items of type \StructType\Car, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Car[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Car|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Car|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Car|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Car|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Car|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Car
     */
    public function getAttributeName()
    {
        return 'Car';
    }
}
