<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewImportPNR.Reservation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewImportPNR.Reservation
 * @subpackage Structs
 */
class ViewImportPNR_Reservation extends AbstractStructBase
{
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The BookingAction
     * @var string
     */
    public $BookingAction;
    /**
     * The BookingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BookingCarrier;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The ExternalAppID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExternalAppID;
    /**
     * The ExternalBookingReference
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExternalBookingReference;
    /**
     * The OriginalBookingDate
     * @var string
     */
    public $OriginalBookingDate;
    /**
     * The ReservationCurrency
     * @var string
     */
    public $ReservationCurrency;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $User;
    /**
     * The PromoCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PromoCode;
    /**
     * The RecieptLanguageCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RecieptLanguageCode;
    /**
     * The ReservationChannel
     * @var int
     */
    public $ReservationChannel;
    /**
     * The Segments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfViewImportPNR_Reservation_Segment
     */
    public $Segments;
    /**
     * The Persons
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfViewImportPNR_Reservation_Person
     */
    public $Persons;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfViewImportPNR_Reservation_Comment
     */
    public $Comments;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfViewImportPNR_Reservation_ImportError
     */
    public $Errors;
    /**
     * Constructor method for ViewImportPNR.Reservation
     * @uses ViewImportPNR_Reservation::setSeriesNumber()
     * @uses ViewImportPNR_Reservation::setConfirmationNumber()
     * @uses ViewImportPNR_Reservation::setBookingAction()
     * @uses ViewImportPNR_Reservation::setBookingCarrier()
     * @uses ViewImportPNR_Reservation::setIATANumber()
     * @uses ViewImportPNR_Reservation::setExternalAppID()
     * @uses ViewImportPNR_Reservation::setExternalBookingReference()
     * @uses ViewImportPNR_Reservation::setOriginalBookingDate()
     * @uses ViewImportPNR_Reservation::setReservationCurrency()
     * @uses ViewImportPNR_Reservation::setUser()
     * @uses ViewImportPNR_Reservation::setPromoCode()
     * @uses ViewImportPNR_Reservation::setRecieptLanguageCode()
     * @uses ViewImportPNR_Reservation::setReservationChannel()
     * @uses ViewImportPNR_Reservation::setSegments()
     * @uses ViewImportPNR_Reservation::setPersons()
     * @uses ViewImportPNR_Reservation::setComments()
     * @uses ViewImportPNR_Reservation::setErrors()
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param string $bookingAction
     * @param string $bookingCarrier
     * @param string $iATANumber
     * @param string $externalAppID
     * @param string $externalBookingReference
     * @param string $originalBookingDate
     * @param string $reservationCurrency
     * @param string $user
     * @param string $promoCode
     * @param string $recieptLanguageCode
     * @param int $reservationChannel
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_Segment $segments
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_Person $persons
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_Comment $comments
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_ImportError $errors
     */
    public function __construct($seriesNumber = null, $confirmationNumber = null, $bookingAction = null, $bookingCarrier = null, $iATANumber = null, $externalAppID = null, $externalBookingReference = null, $originalBookingDate = null, $reservationCurrency = null, $user = null, $promoCode = null, $recieptLanguageCode = null, $reservationChannel = null, \ArrayType\ArrayOfViewImportPNR_Reservation_Segment $segments = null, \ArrayType\ArrayOfViewImportPNR_Reservation_Person $persons = null, \ArrayType\ArrayOfViewImportPNR_Reservation_Comment $comments = null, \ArrayType\ArrayOfViewImportPNR_Reservation_ImportError $errors = null)
    {
        $this
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setBookingAction($bookingAction)
            ->setBookingCarrier($bookingCarrier)
            ->setIATANumber($iATANumber)
            ->setExternalAppID($externalAppID)
            ->setExternalBookingReference($externalBookingReference)
            ->setOriginalBookingDate($originalBookingDate)
            ->setReservationCurrency($reservationCurrency)
            ->setUser($user)
            ->setPromoCode($promoCode)
            ->setRecieptLanguageCode($recieptLanguageCode)
            ->setReservationChannel($reservationChannel)
            ->setSegments($segments)
            ->setPersons($persons)
            ->setComments($comments)
            ->setErrors($errors);
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get BookingAction value
     * @return string|null
     */
    public function getBookingAction()
    {
        return $this->BookingAction;
    }
    /**
     * Set BookingAction value
     * @uses \EnumType\Enumerations_ImportBookingAction::valueIsValid()
     * @uses \EnumType\Enumerations_ImportBookingAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingAction
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setBookingAction($bookingAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_ImportBookingAction::valueIsValid($bookingAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_ImportBookingAction', is_array($bookingAction) ? implode(', ', $bookingAction) : var_export($bookingAction, true), implode(', ', \EnumType\Enumerations_ImportBookingAction::getValidValues())), __LINE__);
        }
        $this->BookingAction = $bookingAction;
        return $this;
    }
    /**
     * Get BookingCarrier value
     * @return string|null
     */
    public function getBookingCarrier()
    {
        return $this->BookingCarrier;
    }
    /**
     * Set BookingCarrier value
     * @param string $bookingCarrier
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setBookingCarrier($bookingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCarrier) && !is_string($bookingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCarrier, true), gettype($bookingCarrier)), __LINE__);
        }
        $this->BookingCarrier = $bookingCarrier;
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get ExternalAppID value
     * @return string|null
     */
    public function getExternalAppID()
    {
        return $this->ExternalAppID;
    }
    /**
     * Set ExternalAppID value
     * @param string $externalAppID
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setExternalAppID($externalAppID = null)
    {
        // validation for constraint: string
        if (!is_null($externalAppID) && !is_string($externalAppID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalAppID, true), gettype($externalAppID)), __LINE__);
        }
        $this->ExternalAppID = $externalAppID;
        return $this;
    }
    /**
     * Get ExternalBookingReference value
     * @return string|null
     */
    public function getExternalBookingReference()
    {
        return $this->ExternalBookingReference;
    }
    /**
     * Set ExternalBookingReference value
     * @param string $externalBookingReference
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setExternalBookingReference($externalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingReference) && !is_string($externalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingReference, true), gettype($externalBookingReference)), __LINE__);
        }
        $this->ExternalBookingReference = $externalBookingReference;
        return $this;
    }
    /**
     * Get OriginalBookingDate value
     * @return string|null
     */
    public function getOriginalBookingDate()
    {
        return $this->OriginalBookingDate;
    }
    /**
     * Set OriginalBookingDate value
     * @param string $originalBookingDate
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setOriginalBookingDate($originalBookingDate = null)
    {
        // validation for constraint: string
        if (!is_null($originalBookingDate) && !is_string($originalBookingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalBookingDate, true), gettype($originalBookingDate)), __LINE__);
        }
        $this->OriginalBookingDate = $originalBookingDate;
        return $this;
    }
    /**
     * Get ReservationCurrency value
     * @return string|null
     */
    public function getReservationCurrency()
    {
        return $this->ReservationCurrency;
    }
    /**
     * Set ReservationCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationCurrency
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setReservationCurrency($reservationCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($reservationCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($reservationCurrency) ? implode(', ', $reservationCurrency) : var_export($reservationCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->ReservationCurrency = $reservationCurrency;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get PromoCode value
     * @return string|null
     */
    public function getPromoCode()
    {
        return $this->PromoCode;
    }
    /**
     * Set PromoCode value
     * @param string $promoCode
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        $this->PromoCode = $promoCode;
        return $this;
    }
    /**
     * Get RecieptLanguageCode value
     * @return string|null
     */
    public function getRecieptLanguageCode()
    {
        return $this->RecieptLanguageCode;
    }
    /**
     * Set RecieptLanguageCode value
     * @param string $recieptLanguageCode
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setRecieptLanguageCode($recieptLanguageCode = null)
    {
        // validation for constraint: string
        if (!is_null($recieptLanguageCode) && !is_string($recieptLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recieptLanguageCode, true), gettype($recieptLanguageCode)), __LINE__);
        }
        $this->RecieptLanguageCode = $recieptLanguageCode;
        return $this;
    }
    /**
     * Get ReservationChannel value
     * @return int|null
     */
    public function getReservationChannel()
    {
        return $this->ReservationChannel;
    }
    /**
     * Set ReservationChannel value
     * @param int $reservationChannel
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setReservationChannel($reservationChannel = null)
    {
        // validation for constraint: int
        if (!is_null($reservationChannel) && !(is_int($reservationChannel) || ctype_digit($reservationChannel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationChannel, true), gettype($reservationChannel)), __LINE__);
        }
        $this->ReservationChannel = $reservationChannel;
        return $this;
    }
    /**
     * Get Segments value
     * @return \ArrayType\ArrayOfViewImportPNR_Reservation_Segment|null
     */
    public function getSegments()
    {
        return $this->Segments;
    }
    /**
     * Set Segments value
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_Segment $segments
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setSegments(\ArrayType\ArrayOfViewImportPNR_Reservation_Segment $segments = null)
    {
        $this->Segments = $segments;
        return $this;
    }
    /**
     * Get Persons value
     * @return \ArrayType\ArrayOfViewImportPNR_Reservation_Person|null
     */
    public function getPersons()
    {
        return $this->Persons;
    }
    /**
     * Set Persons value
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_Person $persons
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setPersons(\ArrayType\ArrayOfViewImportPNR_Reservation_Person $persons = null)
    {
        $this->Persons = $persons;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfViewImportPNR_Reservation_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_Comment $comments
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setComments(\ArrayType\ArrayOfViewImportPNR_Reservation_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Errors value
     * @return \ArrayType\ArrayOfViewImportPNR_Reservation_ImportError|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_ImportError $errors
     * @return \StructType\ViewImportPNR_Reservation
     */
    public function setErrors(\ArrayType\ArrayOfViewImportPNR_Reservation_ImportError $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
}
