<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialService StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SpecialService
 * @subpackage Structs
 */
class SpecialService extends AbstractStructBase
{
    /**
     * The CodeType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodeType;
    /**
     * The ServiceID
     * @var int
     */
    public $ServiceID;
    /**
     * The SSRCategory
     * @var int
     */
    public $SSRCategory;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The OverrideAmount
     * @var bool
     */
    public $OverrideAmount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Commissionable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Commissionable;
    /**
     * The Refundable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Refundable;
    /**
     * The ChargeComment
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ChargeComment;
    /**
     * The PersonOrgID
     * @var int
     */
    public $PersonOrgID;
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The OverrideAmtReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OverrideAmtReason;
    /**
     * The ExtPenaltyRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtPenaltyRule;
    /**
     * The ExtIsRePriceFixed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtIsRePriceFixed;
    /**
     * The ExtRePriceSourceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtRePriceSourceName;
    /**
     * The ExtRePriceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtRePriceValue;
    /**
     * The ExtRePriceValueReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtRePriceValueReason;
    /**
     * The ServiceBundleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceBundleCode;
    /**
     * Constructor method for SpecialService
     * @uses SpecialService::setCodeType()
     * @uses SpecialService::setServiceID()
     * @uses SpecialService::setSSRCategory()
     * @uses SpecialService::setLogicalFlightID()
     * @uses SpecialService::setDepartureDate()
     * @uses SpecialService::setAmount()
     * @uses SpecialService::setOverrideAmount()
     * @uses SpecialService::setCurrencyCode()
     * @uses SpecialService::setCommissionable()
     * @uses SpecialService::setRefundable()
     * @uses SpecialService::setChargeComment()
     * @uses SpecialService::setPersonOrgID()
     * @uses SpecialService::setPhysicalFlightID()
     * @uses SpecialService::setOverrideAmtReason()
     * @uses SpecialService::setExtPenaltyRule()
     * @uses SpecialService::setExtIsRePriceFixed()
     * @uses SpecialService::setExtRePriceSourceName()
     * @uses SpecialService::setExtRePriceValue()
     * @uses SpecialService::setExtRePriceValueReason()
     * @uses SpecialService::setServiceBundleCode()
     * @param string $codeType
     * @param int $serviceID
     * @param int $sSRCategory
     * @param int $logicalFlightID
     * @param string $departureDate
     * @param float $amount
     * @param bool $overrideAmount
     * @param string $currencyCode
     * @param bool $commissionable
     * @param bool $refundable
     * @param string $chargeComment
     * @param int $personOrgID
     * @param int $physicalFlightID
     * @param string $overrideAmtReason
     * @param string $extPenaltyRule
     * @param string $extIsRePriceFixed
     * @param string $extRePriceSourceName
     * @param string $extRePriceValue
     * @param string $extRePriceValueReason
     * @param string $serviceBundleCode
     */
    public function __construct($codeType = null, $serviceID = null, $sSRCategory = null, $logicalFlightID = null, $departureDate = null, $amount = null, $overrideAmount = null, $currencyCode = null, $commissionable = null, $refundable = null, $chargeComment = null, $personOrgID = null, $physicalFlightID = null, $overrideAmtReason = null, $extPenaltyRule = null, $extIsRePriceFixed = null, $extRePriceSourceName = null, $extRePriceValue = null, $extRePriceValueReason = null, $serviceBundleCode = null)
    {
        $this
            ->setCodeType($codeType)
            ->setServiceID($serviceID)
            ->setSSRCategory($sSRCategory)
            ->setLogicalFlightID($logicalFlightID)
            ->setDepartureDate($departureDate)
            ->setAmount($amount)
            ->setOverrideAmount($overrideAmount)
            ->setCurrencyCode($currencyCode)
            ->setCommissionable($commissionable)
            ->setRefundable($refundable)
            ->setChargeComment($chargeComment)
            ->setPersonOrgID($personOrgID)
            ->setPhysicalFlightID($physicalFlightID)
            ->setOverrideAmtReason($overrideAmtReason)
            ->setExtPenaltyRule($extPenaltyRule)
            ->setExtIsRePriceFixed($extIsRePriceFixed)
            ->setExtRePriceSourceName($extRePriceSourceName)
            ->setExtRePriceValue($extRePriceValue)
            ->setExtRePriceValueReason($extRePriceValueReason)
            ->setServiceBundleCode($serviceBundleCode);
    }
    /**
     * Get CodeType value
     * @return string|null
     */
    public function getCodeType()
    {
        return $this->CodeType;
    }
    /**
     * Set CodeType value
     * @param string $codeType
     * @return \StructType\SpecialService
     */
    public function setCodeType($codeType = null)
    {
        // validation for constraint: string
        if (!is_null($codeType) && !is_string($codeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeType, true), gettype($codeType)), __LINE__);
        }
        $this->CodeType = $codeType;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return int|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param int $serviceID
     * @return \StructType\SpecialService
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceID) && !(is_int($serviceID) || ctype_digit($serviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get SSRCategory value
     * @return int|null
     */
    public function getSSRCategory()
    {
        return $this->SSRCategory;
    }
    /**
     * Set SSRCategory value
     * @param int $sSRCategory
     * @return \StructType\SpecialService
     */
    public function setSSRCategory($sSRCategory = null)
    {
        // validation for constraint: int
        if (!is_null($sSRCategory) && !(is_int($sSRCategory) || ctype_digit($sSRCategory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sSRCategory, true), gettype($sSRCategory)), __LINE__);
        }
        $this->SSRCategory = $sSRCategory;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\SpecialService
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\SpecialService
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SpecialService
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get OverrideAmount value
     * @return bool|null
     */
    public function getOverrideAmount()
    {
        return $this->OverrideAmount;
    }
    /**
     * Set OverrideAmount value
     * @param bool $overrideAmount
     * @return \StructType\SpecialService
     */
    public function setOverrideAmount($overrideAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideAmount) && !is_bool($overrideAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideAmount, true), gettype($overrideAmount)), __LINE__);
        }
        $this->OverrideAmount = $overrideAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyCode
     * @return \StructType\SpecialService
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currencyCode) ? implode(', ', $currencyCode) : var_export($currencyCode, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Commissionable value
     * @return bool|null
     */
    public function getCommissionable()
    {
        return $this->Commissionable;
    }
    /**
     * Set Commissionable value
     * @param bool $commissionable
     * @return \StructType\SpecialService
     */
    public function setCommissionable($commissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionable) && !is_bool($commissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionable, true), gettype($commissionable)), __LINE__);
        }
        $this->Commissionable = $commissionable;
        return $this;
    }
    /**
     * Get Refundable value
     * @return bool|null
     */
    public function getRefundable()
    {
        return $this->Refundable;
    }
    /**
     * Set Refundable value
     * @param bool $refundable
     * @return \StructType\SpecialService
     */
    public function setRefundable($refundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundable) && !is_bool($refundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundable, true), gettype($refundable)), __LINE__);
        }
        $this->Refundable = $refundable;
        return $this;
    }
    /**
     * Get ChargeComment value
     * @return string|null
     */
    public function getChargeComment()
    {
        return $this->ChargeComment;
    }
    /**
     * Set ChargeComment value
     * @param string $chargeComment
     * @return \StructType\SpecialService
     */
    public function setChargeComment($chargeComment = null)
    {
        // validation for constraint: string
        if (!is_null($chargeComment) && !is_string($chargeComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeComment, true), gettype($chargeComment)), __LINE__);
        }
        $this->ChargeComment = $chargeComment;
        return $this;
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\SpecialService
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return isset($this->PhysicalFlightID) ? $this->PhysicalFlightID : null;
    }
    /**
     * Set PhysicalFlightID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $physicalFlightID
     * @return \StructType\SpecialService
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        if (is_null($physicalFlightID) || (is_array($physicalFlightID) && empty($physicalFlightID))) {
            unset($this->PhysicalFlightID);
        } else {
            $this->PhysicalFlightID = $physicalFlightID;
        }
        return $this;
    }
    /**
     * Get OverrideAmtReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverrideAmtReason()
    {
        return isset($this->OverrideAmtReason) ? $this->OverrideAmtReason : null;
    }
    /**
     * Set OverrideAmtReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overrideAmtReason
     * @return \StructType\SpecialService
     */
    public function setOverrideAmtReason($overrideAmtReason = null)
    {
        // validation for constraint: string
        if (!is_null($overrideAmtReason) && !is_string($overrideAmtReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideAmtReason, true), gettype($overrideAmtReason)), __LINE__);
        }
        if (is_null($overrideAmtReason) || (is_array($overrideAmtReason) && empty($overrideAmtReason))) {
            unset($this->OverrideAmtReason);
        } else {
            $this->OverrideAmtReason = $overrideAmtReason;
        }
        return $this;
    }
    /**
     * Get ExtPenaltyRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtPenaltyRule()
    {
        return isset($this->ExtPenaltyRule) ? $this->ExtPenaltyRule : null;
    }
    /**
     * Set ExtPenaltyRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extPenaltyRule
     * @return \StructType\SpecialService
     */
    public function setExtPenaltyRule($extPenaltyRule = null)
    {
        // validation for constraint: string
        if (!is_null($extPenaltyRule) && !is_string($extPenaltyRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extPenaltyRule, true), gettype($extPenaltyRule)), __LINE__);
        }
        if (is_null($extPenaltyRule) || (is_array($extPenaltyRule) && empty($extPenaltyRule))) {
            unset($this->ExtPenaltyRule);
        } else {
            $this->ExtPenaltyRule = $extPenaltyRule;
        }
        return $this;
    }
    /**
     * Get ExtIsRePriceFixed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtIsRePriceFixed()
    {
        return isset($this->ExtIsRePriceFixed) ? $this->ExtIsRePriceFixed : null;
    }
    /**
     * Set ExtIsRePriceFixed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extIsRePriceFixed
     * @return \StructType\SpecialService
     */
    public function setExtIsRePriceFixed($extIsRePriceFixed = null)
    {
        // validation for constraint: string
        if (!is_null($extIsRePriceFixed) && !is_string($extIsRePriceFixed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extIsRePriceFixed, true), gettype($extIsRePriceFixed)), __LINE__);
        }
        if (is_null($extIsRePriceFixed) || (is_array($extIsRePriceFixed) && empty($extIsRePriceFixed))) {
            unset($this->ExtIsRePriceFixed);
        } else {
            $this->ExtIsRePriceFixed = $extIsRePriceFixed;
        }
        return $this;
    }
    /**
     * Get ExtRePriceSourceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtRePriceSourceName()
    {
        return isset($this->ExtRePriceSourceName) ? $this->ExtRePriceSourceName : null;
    }
    /**
     * Set ExtRePriceSourceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extRePriceSourceName
     * @return \StructType\SpecialService
     */
    public function setExtRePriceSourceName($extRePriceSourceName = null)
    {
        // validation for constraint: string
        if (!is_null($extRePriceSourceName) && !is_string($extRePriceSourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extRePriceSourceName, true), gettype($extRePriceSourceName)), __LINE__);
        }
        if (is_null($extRePriceSourceName) || (is_array($extRePriceSourceName) && empty($extRePriceSourceName))) {
            unset($this->ExtRePriceSourceName);
        } else {
            $this->ExtRePriceSourceName = $extRePriceSourceName;
        }
        return $this;
    }
    /**
     * Get ExtRePriceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtRePriceValue()
    {
        return isset($this->ExtRePriceValue) ? $this->ExtRePriceValue : null;
    }
    /**
     * Set ExtRePriceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extRePriceValue
     * @return \StructType\SpecialService
     */
    public function setExtRePriceValue($extRePriceValue = null)
    {
        // validation for constraint: string
        if (!is_null($extRePriceValue) && !is_string($extRePriceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extRePriceValue, true), gettype($extRePriceValue)), __LINE__);
        }
        if (is_null($extRePriceValue) || (is_array($extRePriceValue) && empty($extRePriceValue))) {
            unset($this->ExtRePriceValue);
        } else {
            $this->ExtRePriceValue = $extRePriceValue;
        }
        return $this;
    }
    /**
     * Get ExtRePriceValueReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtRePriceValueReason()
    {
        return isset($this->ExtRePriceValueReason) ? $this->ExtRePriceValueReason : null;
    }
    /**
     * Set ExtRePriceValueReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extRePriceValueReason
     * @return \StructType\SpecialService
     */
    public function setExtRePriceValueReason($extRePriceValueReason = null)
    {
        // validation for constraint: string
        if (!is_null($extRePriceValueReason) && !is_string($extRePriceValueReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extRePriceValueReason, true), gettype($extRePriceValueReason)), __LINE__);
        }
        if (is_null($extRePriceValueReason) || (is_array($extRePriceValueReason) && empty($extRePriceValueReason))) {
            unset($this->ExtRePriceValueReason);
        } else {
            $this->ExtRePriceValueReason = $extRePriceValueReason;
        }
        return $this;
    }
    /**
     * Get ServiceBundleCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceBundleCode()
    {
        return isset($this->ServiceBundleCode) ? $this->ServiceBundleCode : null;
    }
    /**
     * Set ServiceBundleCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceBundleCode
     * @return \StructType\SpecialService
     */
    public function setServiceBundleCode($serviceBundleCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceBundleCode) && !is_string($serviceBundleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceBundleCode, true), gettype($serviceBundleCode)), __LINE__);
        }
        if (is_null($serviceBundleCode) || (is_array($serviceBundleCode) && empty($serviceBundleCode))) {
            unset($this->ServiceBundleCode);
        } else {
            $this->ServiceBundleCode = $serviceBundleCode;
        }
        return $this;
    }
}
