<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrievePNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrievePNR
 * @subpackage Structs
 */
class RetrievePNR extends TransactionInfo
{
    /**
     * The RetrievePnrRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrievePNR
     */
    public $RetrievePnrRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * Constructor method for RetrievePNR
     * @uses RetrievePNR::setRetrievePnrRequest()
     * @uses RetrievePNR::setActionType()
     * @uses RetrievePNR::setReservationInfo()
     * @param \StructType\RetrievePNR $retrievePnrRequest
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     */
    public function __construct(\StructType\RetrievePNR $retrievePnrRequest = null, $actionType = null, \StructType\ReservationInfo $reservationInfo = null)
    {
        $this
            ->setRetrievePnrRequest($retrievePnrRequest)
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo);
    }
    /**
     * Get RetrievePnrRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrievePNR|null
     */
    public function getRetrievePnrRequest()
    {
        return isset($this->RetrievePnrRequest) ? $this->RetrievePnrRequest : null;
    }
    /**
     * Set RetrievePnrRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrievePNR $retrievePnrRequest
     * @return \StructType\RetrievePNR
     */
    public function setRetrievePnrRequest(\StructType\RetrievePNR $retrievePnrRequest = null)
    {
        if (is_null($retrievePnrRequest) || (is_array($retrievePnrRequest) && empty($retrievePnrRequest))) {
            unset($this->RetrievePnrRequest);
        } else {
            $this->RetrievePnrRequest = $retrievePnrRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\RetrievePNR_ActionTypes::valueIsValid()
     * @uses \EnumType\RetrievePNR_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\RetrievePNR
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetrievePNR_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetrievePNR_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\RetrievePNR_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\RetrievePNR
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
}
